package com.rocogz.merchant.entity.goods;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 商品标签表
 * </p>
 *
 * @author zhangmin
 * @since 2020-10-23
 */
@Setter @Getter @Accessors(chain = true)
public class MerchantGoodsLabel extends IdEntity {

    /**
     * 商品编码
     */
    private String productCode;

    /**
     * 商品标签编号
     */
    private String labelCode;

    private LocalDateTime createTime;

    //前端页面显示标签名使用
    private transient String labelName;

}