/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.merchant.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.rocogz.merchant.entity.goods.MerchantGoods;
import com.rocogz.merchant.entity.goods.MerchantSkuAttrValue;
import com.rocogz.syy.common.entity.IdEntity;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MerchantSku
extends IdEntity {
    private String productCode;
    private String skuCode;
    private String skuName;
    private String skuImgUrl;
    private String status;
    private BigDecimal cent;
    private BigDecimal minCent;
    private BigDecimal cash;
    private Integer seq;
    @TableField(exist=false)
    private MerchantGoods product;
    @TableField(exist=false)
    private List<MerchantSkuAttrValue> attrValueList;

    public String getSaleAttrValues() {
        if (CollectionUtils.isEmpty(this.attrValueList)) {
            return "";
        }
        Collections.sort(this.attrValueList);
        return this.attrValueList.stream().map(MerchantSkuAttrValue::getAttrValue).collect(Collectors.joining(","));
    }

    public String getPreviewSkuImg() {
        if (StringUtils.isNotBlank((CharSequence)this.skuImgUrl)) {
            return this.skuImgUrl;
        }
        if (this.product != null) {
            return this.product.getListImgUrl();
        }
        return "";
    }

    public MerchantSku setProductCode(String productCode) {
        this.productCode = productCode;
        return this;
    }

    public MerchantSku setSkuCode(String skuCode) {
        this.skuCode = skuCode;
        return this;
    }

    public MerchantSku setSkuName(String skuName) {
        this.skuName = skuName;
        return this;
    }

    public MerchantSku setSkuImgUrl(String skuImgUrl) {
        this.skuImgUrl = skuImgUrl;
        return this;
    }

    public MerchantSku setStatus(String status) {
        this.status = status;
        return this;
    }

    public MerchantSku setCent(BigDecimal cent) {
        this.cent = cent;
        return this;
    }

    public MerchantSku setMinCent(BigDecimal minCent) {
        this.minCent = minCent;
        return this;
    }

    public MerchantSku setCash(BigDecimal cash) {
        this.cash = cash;
        return this;
    }

    public MerchantSku setSeq(Integer seq) {
        this.seq = seq;
        return this;
    }

    public MerchantSku setProduct(MerchantGoods product) {
        this.product = product;
        return this;
    }

    public MerchantSku setAttrValueList(List<MerchantSkuAttrValue> attrValueList) {
        this.attrValueList = attrValueList;
        return this;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getSkuCode() {
        return this.skuCode;
    }

    public String getSkuName() {
        return this.skuName;
    }

    public String getSkuImgUrl() {
        return this.skuImgUrl;
    }

    public String getStatus() {
        return this.status;
    }

    public BigDecimal getCent() {
        return this.cent;
    }

    public BigDecimal getMinCent() {
        return this.minCent;
    }

    public BigDecimal getCash() {
        return this.cash;
    }

    public Integer getSeq() {
        return this.seq;
    }

    public MerchantGoods getProduct() {
        return this.product;
    }

    public List<MerchantSkuAttrValue> getAttrValueList() {
        return this.attrValueList;
    }
}

