package com.rocogz.merchant.client;

import com.rocogz.merchant.dto.TreeDto;
import com.rocogz.merchant.dto.goods.AdminSearchProductParamDto;
import com.rocogz.merchant.dto.goods.GoodsStockAdminAdjustRequestDto;
import com.rocogz.merchant.dto.goods.GoodsStockPageRequestDto;
import com.rocogz.merchant.dto.goods.GoodsVcardStockPageRequestDto;
import com.rocogz.merchant.dto.goodsStock.OrderBatchStockRequestDto;
import com.rocogz.merchant.dto.goodsStock.OrderStockRequestDTO;
import com.rocogz.merchant.dto.goodsStock.OrderVCardResponseItem;
import com.rocogz.merchant.dto.goodsVcard.VCardToVoidRequestDTO;
import com.rocogz.merchant.dto.label.GoodsLabelParam;
import com.rocogz.merchant.dto.label.LabelSearchParam;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.merchant.entity.goods.*;
import com.rocogz.merchant.entity.identity.MerchantStoreAccountIdentity;
import com.rocogz.merchant.entity.label.MerchantLabel;
import com.rocogz.merchant.entity.supplier.MerchantSupplier;
import com.rocogz.merchant.entity.supplier.MerchantSupplierUlog;
import com.rocogz.merchant.entity.supplier.MerchantSupplierWarehouse;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 商户接口
 *
 * @author：liangyongtong
 * @since：2020/3/25
 */
@SuppressWarnings("all")
public interface IMerchantClientService {


    /*********************************************  yinshihao 商户品牌相关 Start   ****************************************************************/
    /**
     * 查询商户品牌列表(分页)
     *
     * @param code             品牌名
     * @param keyword          所属行业编码
     * @param status           品牌状态
     * @param page             页码
     * @param limit            每页条数
     * @return
     */
    @GetMapping("/api/merchant/brand")
    PageTable<MerchantBrand> findMerchantBrandList(@RequestParam(value = "code", required = false) String code,
                                                   @RequestParam(value = "keyword", required = false) String keyword,
                                                   @RequestParam(value = "status", required = false) String status,
                                                   @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                   @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 新增或编辑商户品牌
     *
     * @param merchantBrand 商户品牌
     * @return
     */
    @PostMapping("/api/merchant/brand/saveOrUpdateMerchantBrand")
    Response saveOrUpdateMerchantBrand(@RequestBody MerchantBrand merchantBrand);


    /**
     * 改变商户品牌状态
     *
     * @param merchantBrand 商户品牌
     * @return
     */
    @PostMapping("/api/merchant/brand/status")
    Response switchMerchantBrandStatus(@RequestBody MerchantBrand merchantBrand);

    /**
     * 根据id查询商户品牌信息
     *
     * @param id 商户品牌id
     * @return
     */
    @GetMapping("/api/merchant/brand/{id}")
    Response<MerchantBrand> getMerchantBrandById(@PathVariable("id") Integer id);

    /**
     * 获取启用的品牌列表
     *
     * @param industryCode 行业编码
     * @return
     */
    @GetMapping("/api/merchant/brand/listWithOpen")
    Response<List<MerchantBrand>> getMerchantBrandListWithOpen();

    /*********************************************   yinshihao 商户品牌 end   ********************************************************************/

    /*********************************************   yinshihao MerchantGoods start   ********************************************************************/

    /**
     * 后台搜索 sku
     * @param searchParamDto
     * @return
     */
    @GetMapping("/api/merchant/sku/adminSearch")
    PageTable<MerchantSku> adminSearchSku(@SpringQueryMap AdminSearchProductParamDto searchParamDto);


    /**
     * 通过skuCode获取sku列表,关联的sku销售属性值也一起加载
     * @param skuCodeList
     * @param isLoadRelateProduct 是否加载关联的product信息
     */
    @GetMapping("/api/merchant/sku/findBySkuCodeList")
    Response<List<MerchantSku>> findSkuListBySkuCodesIn(@RequestParam(value = "skuCodeList") List<String> skuCodeList,
                                                       @RequestParam(value = "isLoadRelateProduct",defaultValue = "false") Boolean isLoadRelateProduct);

    /**
     * 通过skuCode获取sku列表,关联的sku销售属性值也一起加载
     * @param skuCode
     * @param isLoadDetail 是否加载关联的【product,销售属性,详情详情图列表】
     */
    @GetMapping("/api/merchant/sku/getDetailBySkuCode")
    Response<MerchantSku> getSkuInfoBySkuCode(@RequestParam(value = "skuCode") String skuCode,
                                              @RequestParam(value = "isLoadDetail",defaultValue = "false") Boolean isLoadDetail);


    /**
     * 前端页面 切换选择sku
     * @param productCode 商品编号
     * @param selectedAttrValues 选择的sku属性值,例如：白色,XL
     */
    @GetMapping("/api/merchant/sku/getSkuBySelectedAttrValues")
    Response<MerchantSku> getSkuBySelectedAttrValues(@RequestParam(value = "productCode") String productCode,
                                                     @RequestParam(value = "selectedAttrValues") String selectedAttrValues);


    /**
     * 新增/修改商品
     */
    @PostMapping("/api/merchant/goods/saveUpdate")
    Response<String> saveUpdateMerchantGoods(@RequestBody MerchantGoods goods);

    /**
     * 查询主商品信息列表（只返回主商品信息）
     *
     * @param keyword                 名称 模糊匹配
     * @param productCode             商品编码 模糊匹配
     * @param brandCode               品牌编码 全匹配
     * @param supplierCode            供应商编码 全匹配
     * @param classifyCode 商品分类编码 全匹配
     * @param status                  商品状态
     * @param isVirtual               是否虚拟商品
     * @param limit                   每页条数
     * @param page                    页码
     * @return
     */
    @GetMapping("/api/merchant/goods/queryPage")
    PageTable<MerchantGoods> merchantGoodsPageTable(@RequestParam(value="keyword",required = false) String keyword,
                                                   @RequestParam(value="productCode",required = false) String productCode,
                                                   @RequestParam(value="brandCode",required = false) String brandCode,
                                                   @RequestParam(value="classifyCode",required = false) String classifyCode,
                                                   @RequestParam(value="status",required = false) String status,
                                                   @RequestParam(value="supplierCodeList",required = false) List<String> supplierCodeList,
                                                   @RequestParam(value="isVirtual",required = false) Boolean isVirtual,
                                                   @RequestParam(value="limit",defaultValue = "20") int limit,
                                                   @RequestParam(value="page",defaultValue = "1") int page);

    /**
     * 操作商品状态
     *
     * @param code       商品编码
     * @param status     目标商品状态
     * @param updateUser 操作人
     */
    @GetMapping("/api/merchant/goods/operateStatus")
    Response updateMerchantGoodStatus(@RequestParam(value = "productCode") String productCode,
                                      @RequestParam(value = "newStatus")   String newStatus,
                                      @RequestParam(value = "updateUser") String updateUser);


    /**
     * 审批回调更改状态（上架审批后回调）
     *
     * @param pass
     * @param code
     * @param updateUser
     * @return
     */
    @GetMapping("/api/merchant/goods/goodsApproveCallBlack")
    Response goodsApproveCallBlack(@RequestParam(value = "pass") String pass, @RequestParam(value = "code") String code, @RequestParam(value = "updateUser") String updateUser);

    /**
     * 根据商品编码 删除商品
     *
     * @param code 商品编码
     * @return
     */
    @GetMapping("/api/merchant/goods/deleteGoodByCode")
    Response deleteMerchantGoodByCode(@RequestParam(value = "productCode") String productCode);


    /**
     * 根据商品编码获取商品信息
     * @param productCode 商品编码
     * @param isLoadDetail 是否加载商品详情（供应商,分类，品牌,图片列表,sku列表）
     */
    @GetMapping("/api/merchant/goods/getByCode")
    Response<MerchantGoods> getMerchangGoodByCode(@RequestParam(value="productCode") String productCode,
                                                  @RequestParam(value = "isLoadDetail",defaultValue = "false") Boolean isLoadDetail);

    /**
     * 批量操作状态上架下架
     *
     * @param codes       待操作的商户服务项目编码列表
     * @param status      目标状态
     * @param operateUser 操作人
     * @return
     */
    @GetMapping("/api/merchant/goods/batch/status")
    Response batchListDeListMerchantGoods(@RequestParam(value = "codes") String[] codes, @RequestParam(value = "newStatus") String newStatus, @RequestParam(value = "operateUser") String operateUser);

    /**
     * 根据商品分类编码获取商品列表(基本信息)
     *
     * @param classifyCode 商品分类编码
     * @return
     */
    @GetMapping("/api/merchant/goods/findGoodsListByCassifyCode")
    Response<List<MerchantGoods>> findGoodsListByClassificationCode(@RequestParam("classifyCode") String classifyCode);


    /**
     * 根据商品编码列表查询 主商品信息(只包含主商品信息)
     * @param productCodeList 主商品编号列表
     */
    @GetMapping("/api/merchant/goods/findGoodsListByCodes")
    Response<List<MerchantGoods>> findMerchantGoodsListByCodes(@RequestParam(value = "productCodeList") List<String> productCodeList);

    /**
     * 根据商品编码列表查询 主商品信息 带Sku信息
     */
    @GetMapping("/api/merchant/goods/findMerchantGoodsListByCodesWithSku")
    Response<List<MerchantGoods>> findMerchantGoodsListByCodesWithSku(@RequestParam(value = "productCodeList") List<String> productCodeList);

    /**
     * 根据商品编码列表查询 主商品信息(只包含主商品信息),带查询条件
     */
    @GetMapping("/api/merchant/goods/findGoodsListByCodesWithCondition")
    Response<List<MerchantGoods>> findGoodsListByCodesWithCondition(@RequestParam(name = "productCodeList") List<String> productCodeList,
                                                                           @RequestParam(name = "name", required = false) String name,
                                                                           @RequestParam(name = "code", required = false) String code);
    /*********************************************   yinshihao MerchantGoods end   ********************************************************************/

    /*********************************************   yinshihao MerchantGoodsLog start   ********************************************************************/

    /**
     * 商品操作日期记录
     *
     * @param goodsCode 商品编码
     * @param limit     每页条数
     * @param page      页码
     * @return
     */
    @GetMapping("/api/merchant/goodsLog/queryPage")
    PageTable<MerchantGoodsLog> merchantGoodsLogPageTable(@RequestParam(value = "goodsCode") String goodsCode,
                                                          @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                          @RequestParam(value = "page", defaultValue = "1") int page);

    /*********************************************   yinshihao MerchantGoodsLog end   ********************************************************************/

    /********************************************* yifenrui 供应商  start******************************************************/

    /**
     * 供应商列表
     *
     * @param code
     * @param name
     * @param status
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/supplier")
    PageTable<MerchantSupplier> searchSupplier(@RequestParam(name = "code", required = false) String code,
                                               @RequestParam(name = "name", required = false) String name,
                                               @RequestParam(name = "status", required = false) String status,
                                               @RequestParam(name = "supplierCodeList", required = false) List<String> supplierCodeList,
                                               @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                               @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 新增和更新供应商
     *
     * @param merchantSupplier
     * @return
     */
    @PostMapping("/api/merchant/supplier/createOrUpdateMerchantSupplier")
    Response createOrUpdateMerchantSupplier(@RequestBody MerchantSupplier merchantSupplier);

    /**
     * 根据供应商编码获取供应商详情
     *
     * @param code 供应商编码
     * @return
     */
    @GetMapping("/api/merchant/supplier/supplierDetail")
    Response<MerchantSupplier> merchantMerchantSupplierDetailByCode(@RequestParam(value = "code") String code);

    /**
     * 操作供应商状态
     *
     * @param code       供应商编码
     * @param status     目标供应商状态
     * @param updateUser 更新用户
     * @return
     */
    @GetMapping("/api/merchant/supplier/operateStatus")
    Response merchantSupplierStatusOperate(@RequestParam(value = "code") String code, @RequestParam(value = "status") String status, @RequestParam(value = "updateUser") String updateUser, @RequestParam(value = "reason", required = false) String reason);

    /**
     * 供应商操作日志记录
     *
     * @param supplierCode 商户编码
     * @param limit        每页条数
     * @param page         页码
     * @return
     */
    @GetMapping("/api/merchant/supplier/ulog/queryPage")
    PageTable<MerchantSupplierUlog> merchantSupplierUlogPageTable(@RequestParam(value = "supplierCode") String supplierCode,
                                                                  @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                  @RequestParam(value = "page", defaultValue = "1") int page);
    /********************************************* yifenrui 供应商  end******************************************************/

    /********************************************* yifenrui 商品分类  start******************************************************/
    /**
     * 获取商品分类树.
     *
     * @return
     */
    @GetMapping("/api/merchant/goods/classification/getTree")
    Response<List<TreeDto<MerchantGoodsClassification>>> getMerchantGoodsClassificationTree();

    /**
     * 根据id查询商品分类.
     *
     * @param id the id
     * @return the by id
     */
    @GetMapping("/api/merchant/goods/classification/{id}")
    Response<MerchantGoodsClassification> getMerchantGoodsClassificationById(@PathVariable("id") Integer id);

    /**
     * 根据商品分类编码获取下级列表.
     *
     * @param goodsClassificationCode 服务分类编码
     * @return the response
     */
    @GetMapping("/api/merchant/goods/classification/listByGoodsClassificationCode")
    Response<List<MerchantGoodsClassification>> listByGoodsClassificationCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    @GetMapping("/api/merchant/goods/classification/deleteByGoodsClassCode")
    Response deleteByGoodsClassCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    /**
     * 分页查询商品分类列表
     *
     * @param code
     * @param name
     * @param status
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/merchant/goods/classification")
    PageTable<MerchantGoodsClassification> searchMerchantGoodsClassification(@RequestParam(name = "code", required = false) String code,
                                                                             @RequestParam(name = "name", required = false) String name,
                                                                             @RequestParam(name = "status", required = false) String status,
                                                                             @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                                                             @RequestParam(name = "page", defaultValue = "1") Integer page);

    @PostMapping("/api/merchant/goods/classification/saveOrUpdate")
    Response saveOrUpdateMerchantGoodsClassification(@RequestBody MerchantGoodsClassification merchantGoodsClassification);

    /**
     * 前台获取启用状态商品分类树.
     *
     * @return the prefecture tree
     */
    @GetMapping("/api/merchant/goods/classification/getOpenTree")
    Response<List<TreeDto<MerchantGoodsClassification>>> getOpenTree();

    /**
     * 前台根据商品分类编码查询其启用状态的下级列表
     *
     * @param goodsClassificationCode 商品分类编码
     * @return the response
     */
    @GetMapping("/api/merchant/goods/classification/openListByGoodsClassificationCode")
    public Response<List<MerchantGoodsClassification>> openListByGoodsClassificationCode(@RequestParam("goodsClassificationCode") String goodsClassificationCode);

    /********************************************* yifenrui 商品分类  end******************************************************/

    /********************************************* huhailong 商品库存  start******************************************************/
    /**
     * 库存列表
     *
     * @param goodsCode               商品编码
     * @param goodsName               商品名称
     * @param brandCode               品牌编码
     * @param supplierCode            品牌名称
     * @param goodsClassificationCode 分类编码
     * @param orderBy                 排序字段
     * @param direction               生序降序
     * @param limit                   每页多少条
     * @param page                    当前第几页
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/queryPage")
    PageTable<MerchantGoodsStock> merchantGoodsStockPageTable(@SpringQueryMap GoodsStockPageRequestDto requestDto);

    /**
     * 获取详细信息，调整库存时使用
     *
     * @param goodsCode
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/getFullInfoByGoodsCode")
    Response<MerchantGoodsStock> getFullInfoByGoodsCode(@RequestParam(value = "goodsCode") String goodsCode);

    /**
     * 适用于后台库存调整 增加，减少，预警调整
     *
     * @param stockAdjustRequest
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/adjustStock")
    Response adjustStock(@RequestBody GoodsStockAdminAdjustRequestDto stockAdjustRequest);

    /**
     * 库存调整日志分页
     *
     * @param goodsCode 商品编码
     * @param limit     每页多少条
     * @param page      当前第几页
     * @return
     */
    @GetMapping("/api/merchant/goodsstocklog/queryPage")
    PageTable<MerchantGoodsStockLog> merchantGoodsStockLogPageTable(
            @RequestParam(value = "goodsCode", required = false) String goodsCode,
            @RequestParam(value = "limit", defaultValue = "20") int limit,
            @RequestParam(value = "page", defaultValue = "1") int page);

    /********************************************* huhailong 商品分类  end******************************************************/


    /********************************************* huhl 数据权限管理  start******************************************************/
    @GetMapping("/api/merchant/supplier/supplierList")
    Response<List<MerchantSupplier>> merchantSupplierList();

    /********************************************* huhl 数据权限管理  end******************************************************/

    /******************************************************huhl 订单库存操作 start******************************************************************/
    /**
     * 订单库存占用
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderStockOccupied")
    Response orderStockOccupied(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 订单库存扣减
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderStockReduce")
    Response orderStockOut(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 订单库存还原
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderStockCancel")
    Response orderStockCancel(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 虚拟库存发货,传递订单号
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderVCardSend")
    Response orderVCardSend(@RequestBody OrderStockRequestDTO orderStockRequestDTO);

    /**
     * 根据订单号获取卡密，只传递订单号就行
     *
     * @param orderNo
     * @return
     */
    @GetMapping("/api/merchant/goodsstock/getVCardByOrderNo")
    Response<List<OrderVCardResponseItem>> getVCardByOrderNo(@RequestParam("orderNo") String orderNo);

    /**
     * 展示
     *
     * @param query
     * @return
     */
    @PostMapping("/api/merchant/goodsvcardstock/queryPage")
    PageTable<MerchantGoodsVCardStock> merchantGoodsVCardStockPageTable(@RequestBody GoodsVcardStockPageRequestDto query);

    /**
     * 导入
     *
     * @param vCardStocks
     * @return
     */
    @PostMapping("/api/merchant/goodsvcardstock/importBatchVCard")
    Response<Integer> importBatchVCard(@RequestBody List<MerchantGoodsVCardStock> vCardStocks);

    /**
     * huhl 添加，得到用户供应商权限中的所有虚拟商品编码，为了导入虚拟卡时进行校验
     *
     * @return
     */
    @PostMapping("/api/merchant/goods/getSupplierInventedGoodsCodeList")
    Response<List<String>> getSupplierInventedGoodsCodeList(@RequestBody List<String> supplierCodeList);

    /**
     * @param requestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsvcardstock/setVCardToVoid")
    Response setVCardToVoid(@RequestBody VCardToVoidRequestDTO requestDTO);

    /**
     * 更新无效库存任务
     *
     * @return
     */
    @GetMapping("/api/merchant/goodsvcardstock/updateVCardExpireTask")
    Response updateVCardExpireTask();

    /*******************************************************huhl 订单库存操作 end**************************************************/


    /*********************************************************huhailong 购物车形式订单库存操作***************************************/

    /**
     * 类似购物车形式的 订单库存占用
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchStockOccupied")
    Response orderBatchStockOccupied(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 类似购物车形式的 订单库存发货扣减
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchStockReduce")
    Response orderBatchStockReduce(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 类似购物车形式的 订单库存还原
     *
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchStockCancel")
    Response orderBatchStockCancel(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 类似购物车形式的 订单虚拟卡发货
     * @param orderStockRequestDTO
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/orderBatchVCardSend")
    Response orderBatchVCardSend(@RequestBody @Validated OrderBatchStockRequestDto orderStockRequestDTO);

    /*********************************************************huhailong 购物车形式订单库存操作 end***************************************/

    // =========  start of  商户身份   ===========

    /**
     * Save or update merchant identity response.
     *
     * @param merchantIdentity the merchant identity
     * @return the response
     */
    @PostMapping("/api/merchant/merchant-identity")
    Response saveOrUpdateMerchantIdentity(@RequestBody MerchantStoreAccountIdentity merchantIdentity);

    /**
     * List merchant identity response.
     *
     * @param storeAccountCode the storeAccountCode
     * @return the response
     */
    @GetMapping("/api/merchant/merchant-identity/list")
    Response<List<MerchantStoreAccountIdentity>> listMerchantStoreIdentity(@RequestParam(value = "storeAccountCode", required = false) String storeAccountCode,
                                                                           @RequestParam(value = "identityTypeCode", required = false) String identityTypeCode);
    // =========  end of  商户身份   ===========


    /*********************************************************huhailong 购物车形式订单库存操作 begin***************************************/

    /**
     * 业务端 订单库存重复占用，场景订单占用库存，取消后，重新占用库存.
     * 会删除流水记录，重新占用库存
     * @param orderStockRequestDTO 多个商品的库存占用
     * @return
     */
     @PostMapping("/api/merchant/goodsstock/orderBatchStockRepeatOccupied")
     Response orderBatchStockRepeatOccupied(OrderBatchStockRequestDto orderStockRequestDTO);

    /**
     * 通过商户编码查询可用库存
     * @param codes 商品编码列表
     * @return
     */
    @PostMapping("/api/merchant/goodsstock/merchantGoodsSellableStock")
    Response<List<MerchantGoodsStock>> merchantGoodsSellableStock(@RequestBody List<String> codes);
    /*********************************************************huhailong 购物车形式订单库存操作 end***************************************/


    /*****************************************   商户标签接口start      ***************************************/
    /**
     * 查询商户标签列表
     *
     * @param code   编号
     * @param name   名称
     * @param status 状态
     * @param limit  每页大小
     * @param page   偏移量
     * @return
     */
    @GetMapping("/api/merchant/label")
    PageTable<MerchantLabel> searchLabel(@RequestParam(name = "code", required = false) String code,
                                         @RequestParam(name = "name", required = false) String name,
                                         @RequestParam(name = "status", required = false) String status,
                                         @RequestParam(name = "limit", defaultValue = "20") int limit,
                                         @RequestParam(name = "page", defaultValue = "1") int page);

    /**
     * 创建或者编辑商户标签
     *
     * @param label 标签信息
     * @return
     */
    @PostMapping("/api/merchant/label/saveOrUpdateLabel")
    Response saveOrUpdateLabel(@RequestBody MerchantLabel label);

    /**
     * 切换标签状态
     *
     * @param id     标签id
     * @param status 状态
     * @return
     */
    @GetMapping("/api/merchant/label/switchStatus")
    Response switchStatus(@RequestParam(name = "id") Integer id, @RequestParam(name = "status") String status);

    /**
     * 根据id查询
     *
     * @param id id
     * @return
     */
    @GetMapping("/api/merchant/label/{id}/get")
    Response getById(@PathVariable("id") Integer id);

    /**
     * 根据codes查询标签列表
     *
     * @param param 查询参数
     * @return
     */
    @PostMapping("/api/merchant/label/findLabelByCodes")
    Response<List<MerchantLabel>> findLabelByCodes(@RequestBody LabelSearchParam param);

    /**
     * 根据标签编号查询关联记录
     *
     * @param labelCode 标签编号
     * @return
     */
    @GetMapping("/api/merchant/label/findGoodsLabelByLabelCode")
    Response<List<MerchantGoodsLabel>> findGoodsLabelByLabelCode(@RequestParam(name = "labelCode") String labelCode);

    /**
     * 删除商品标签关联
     *
     * @param id 关联id
     * @return
     */
    @GetMapping("/api/merchant/label/deleteGoodsLabel")
    Response deleteGoodsLabelById(@RequestParam(name = "id") Integer id);

    /**
     * 保存标签商品的关联关系
     *
     * @return
     */
    @PostMapping("/api/merchant/label/saveGoodsLabels")
    Response saveGoodsLabels(@RequestBody GoodsLabelParam param);
    /*****************************************   商户标签接口end      ***************************************/


    /******获取供应商仓库hhl****************/
    /**
     * 获取供应商的仓库，根据供应商编码
     * @param supplierCode
     * @return
     */
    @GetMapping("/api/merchant/supplier/supplierWarehouse")
    Response<MerchantSupplierWarehouse> merchantSupplierWarehouse(@RequestParam("supplierCode") String supplierCode);

}

