package com.rocogz.merchant.dto.goods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.merchant.pager.Sort;
import lombok.Data;
import org.springframework.util.StringUtils;

/**
 * wap/小程序 管理 搜索商品参数Dto
 * @author zhangmin
 * @date 2020/6/15
 */
@Data
public class WapSearchProductParamDto {

    /**
     * 商品名称 搜索关键词
     */
    private String keyword;

    /**
     * 商品分类编号
     */
    private String classifyCode;

    /**
     * 商品标签Code
     */
    private String labelCode;

    /**
     * 搜索积分范围
     */
    private Integer centRangeStart;

    private Integer centRangeEnd;

    /**
     * 排序字段,排序方式
     */
    private Sort.Order  order;

    private Integer limit = 20;

    private Integer page = 1;

    @JsonIgnore
    public String getLikeKeyWord() {
        if(StringUtils.isEmpty(keyword)) {
            return null;
        }

        return "%" + keyword + "%";
    }
}
