package com.rocogz.merchant.dto.goods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.merchant.pager.Sort;
import lombok.Data;
import org.springframework.util.StringUtils;

/**
 * wap/小程序 管理 搜索商品参数Dto
 * @author zhangmin
 * @date 2020/6/15
 */
@Data
public class WapSearchProductParamDto {

    /**
     * 商品名称 搜索关键词
     */
    private String keyword;

    /**
     * 商品分类编号
     */
    private String classifyCode;

    /**
     * 商品标签Code
     */
    private String labelCode;

    /**
     * 搜索积分范围
     */
    private Integer centRangeStart;

    private Integer centRangeEnd;

    /**
     * 排序,默认按照上架时间倒序排列
     */
    private Sort.Order  order = new Sort.Order(Sort.Direction.DESC,"update_time");

    //每页显示记录条数
    private Integer limit = 20;

    //页码
    private Integer page = 1;

    @JsonIgnore
    public String getLikeKeyWord() {
        if(StringUtils.isEmpty(keyword)) {
            return null;
        }

        return "%" + keyword + "%";
    }

    @JsonIgnore
    public  Integer getOffset() {
        return page > 0 ? (page - 1) * limit : 0;
    }
}
