/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.merchant.client;

import com.rocogz.merchant.dto.TreeDto;
import com.rocogz.merchant.dto.goods.AdminSearchProductParamDto;
import com.rocogz.merchant.dto.goods.GoodsStockAdminAdjustRequestDto;
import com.rocogz.merchant.dto.goods.GoodsStockPageRequestDto;
import com.rocogz.merchant.dto.goods.GoodsVcardStockPageRequestDto;
import com.rocogz.merchant.dto.goods.SkuSelectParamDto;
import com.rocogz.merchant.dto.goods.WapSearchProductParamDto;
import com.rocogz.merchant.dto.goodsStock.OrderBatchStockRequestDto;
import com.rocogz.merchant.dto.goodsStock.OrderStockRequestDTO;
import com.rocogz.merchant.dto.goodsStock.OrderVCardResponseItem;
import com.rocogz.merchant.dto.goodsVcard.VCardToVoidRequestDTO;
import com.rocogz.merchant.dto.label.GoodsLabelParam;
import com.rocogz.merchant.dto.label.LabelSearchParam;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.merchant.entity.goods.MerchantGoods;
import com.rocogz.merchant.entity.goods.MerchantGoodsClassification;
import com.rocogz.merchant.entity.goods.MerchantGoodsLabel;
import com.rocogz.merchant.entity.goods.MerchantGoodsLog;
import com.rocogz.merchant.entity.goods.MerchantGoodsStock;
import com.rocogz.merchant.entity.goods.MerchantGoodsStockLog;
import com.rocogz.merchant.entity.goods.MerchantGoodsVCardStock;
import com.rocogz.merchant.entity.goods.MerchantSku;
import com.rocogz.merchant.entity.identity.MerchantStoreAccountIdentity;
import com.rocogz.merchant.entity.label.MerchantLabel;
import com.rocogz.merchant.entity.supplier.MerchantSupplier;
import com.rocogz.merchant.entity.supplier.MerchantSupplierUlog;
import com.rocogz.merchant.entity.supplier.MerchantSupplierWarehouse;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import java.util.List;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface IMerchantClientService {
    @GetMapping(value={"/api/merchant/brand"})
    public PageTable<MerchantBrand> findMerchantBrandList(@RequestParam(value="code", required=false) String var1, @RequestParam(value="keyword", required=false) String var2, @RequestParam(value="status", required=false) String var3, @RequestParam(value="limit", defaultValue="20") int var4, @RequestParam(value="page", defaultValue="1") int var5);

    @PostMapping(value={"/api/merchant/brand/saveOrUpdateMerchantBrand"})
    public Response saveOrUpdateMerchantBrand(@RequestBody MerchantBrand var1);

    @PostMapping(value={"/api/merchant/brand/status"})
    public Response switchMerchantBrandStatus(@RequestBody MerchantBrand var1);

    @GetMapping(value={"/api/merchant/brand/{id}"})
    public Response<MerchantBrand> getMerchantBrandById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/merchant/brand/listWithOpen"})
    public Response<List<MerchantBrand>> getMerchantBrandListWithOpen();

    @GetMapping(value={"/api/merchant/sku/adminSearch"})
    public PageTable<MerchantSku> adminSearchSku(@SpringQueryMap AdminSearchProductParamDto var1);

    @GetMapping(value={"/api/merchant/sku/wapSearch"})
    public PageTable<MerchantSku> wapSearchSku(@SpringQueryMap WapSearchProductParamDto var1);

    @GetMapping(value={"/api/merchant/sku/findBySkuCodeList"})
    public Response<List<MerchantSku>> findSkuListBySkuCodesIn(@RequestParam(value="skuCodeList") List<String> var1, @RequestParam(value="isLoadRelateProduct", defaultValue="false") Boolean var2);

    @GetMapping(value={"/api/merchant/sku/getDetailBySkuCode"})
    public Response<MerchantSku> getSkuInfoBySkuCode(@RequestParam(value="skuCode") String var1, @RequestParam(value="isLoadDetail", defaultValue="false") Boolean var2);

    @GetMapping(value={"/api/merchant/sku/getWithProduct/{skuCode}"})
    public Response<MerchantSku> getSkuWithProductBySkuCode(@PathVariable(value="skuCode") String var1);

    @PostMapping(value={"/api/merchant/sku/getSkuBySelectedAttrValues"})
    public Response<MerchantSku> getSkuBySelectedAttrValues(@RequestBody SkuSelectParamDto var1);

    @PostMapping(value={"/api/merchant/goods/saveUpdate"})
    public Response<String> saveUpdateMerchantGoods(@RequestBody MerchantGoods var1);

    @GetMapping(value={"/api/merchant/goods/queryPage"})
    public PageTable<MerchantGoods> merchantGoodsPageTable(@RequestParam(value="keyword", required=false) String var1, @RequestParam(value="productCode", required=false) String var2, @RequestParam(value="brandCode", required=false) String var3, @RequestParam(value="classifyCode", required=false) String var4, @RequestParam(value="status", required=false) String var5, @RequestParam(value="supplierCodeList", required=false) List<String> var6, @RequestParam(value="isVirtual", required=false) Boolean var7, @RequestParam(value="limit", defaultValue="20") int var8, @RequestParam(value="page", defaultValue="1") int var9);

    @GetMapping(value={"/api/merchant/goods/operateStatus"})
    public Response updateMerchantGoodStatus(@RequestParam(value="productCode") String var1, @RequestParam(value="newStatus") String var2, @RequestParam(value="updateUser") String var3);

    @GetMapping(value={"/api/merchant/goods/goodsApproveCallBlack"})
    public Response goodsApproveCallBlack(@RequestParam(value="pass") String var1, @RequestParam(value="code") String var2, @RequestParam(value="updateUser") String var3);

    @GetMapping(value={"/api/merchant/goods/deleteGoodByCode"})
    public Response deleteMerchantGoodByCode(@RequestParam(value="productCode") String var1);

    @GetMapping(value={"/api/merchant/goods/getByCode"})
    public Response<MerchantGoods> getMerchangGoodByCode(@RequestParam(value="productCode") String var1, @RequestParam(value="isLoadDetail", defaultValue="false") Boolean var2);

    @GetMapping(value={"/api/merchant/goods/batch/status"})
    public Response batchListDeListMerchantGoods(@RequestParam(value="codes") String[] var1, @RequestParam(value="newStatus") String var2, @RequestParam(value="operateUser") String var3);

    @GetMapping(value={"/api/merchant/goods/findGoodsListByCassifyCode"})
    public Response<List<MerchantGoods>> findGoodsListByClassificationCode(@RequestParam(value="classifyCode") String var1);

    @GetMapping(value={"/api/merchant/goods/findGoodsListByCodes"})
    public Response<List<MerchantGoods>> findMerchantGoodsListByCodes(@RequestParam(value="productCodeList") List<String> var1);

    @GetMapping(value={"/api/merchant/goods/findGoodsListByCodesWithSku"})
    public Response<List<MerchantGoods>> findMerchantGoodsListByCodesWithSku(@RequestParam(value="productCodeList") List<String> var1);

    @GetMapping(value={"/api/merchant/goods/findGoodsListByCodesWithCondition"})
    public Response<List<MerchantGoods>> findGoodsListByCodesWithCondition(@RequestParam(name="productCodeList") List<String> var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="code", required=false) String var3);

    @GetMapping(value={"/api/merchant/goodsLog/queryPage"})
    public PageTable<MerchantGoodsLog> merchantGoodsLogPageTable(@RequestParam(value="goodsCode") String var1, @RequestParam(value="limit", defaultValue="20") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/merchant/supplier"})
    public PageTable<MerchantSupplier> searchSupplier(@RequestParam(name="code", required=false) String var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="status", required=false) String var3, @RequestParam(name="supplierCodeList", required=false) List<String> var4, @RequestParam(name="limit", defaultValue="20") Integer var5, @RequestParam(name="page", defaultValue="1") Integer var6);

    @PostMapping(value={"/api/merchant/supplier/createOrUpdateMerchantSupplier"})
    public Response createOrUpdateMerchantSupplier(@RequestBody MerchantSupplier var1);

    @GetMapping(value={"/api/merchant/supplier/supplierDetail"})
    public Response<MerchantSupplier> merchantMerchantSupplierDetailByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"/api/merchant/supplier/operateStatus"})
    public Response merchantSupplierStatusOperate(@RequestParam(value="code") String var1, @RequestParam(value="status") String var2, @RequestParam(value="updateUser") String var3, @RequestParam(value="reason", required=false) String var4);

    @GetMapping(value={"/api/merchant/supplier/ulog/queryPage"})
    public PageTable<MerchantSupplierUlog> merchantSupplierUlogPageTable(@RequestParam(value="supplierCode") String var1, @RequestParam(value="limit", defaultValue="20") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/merchant/goods/classification/getTree"})
    public Response<List<TreeDto<MerchantGoodsClassification>>> getMerchantGoodsClassificationTree();

    @GetMapping(value={"/api/merchant/goods/classification/{id}"})
    public Response<MerchantGoodsClassification> getMerchantGoodsClassificationById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/merchant/goods/classification/listByGoodsClassificationCode"})
    public Response<List<MerchantGoodsClassification>> listByGoodsClassificationCode(@RequestParam(value="goodsClassificationCode") String var1);

    @GetMapping(value={"/api/merchant/goods/classification/deleteByGoodsClassCode"})
    public Response deleteByGoodsClassCode(@RequestParam(value="goodsClassificationCode") String var1);

    @GetMapping(value={"/api/merchant/goods/classification"})
    public PageTable<MerchantGoodsClassification> searchMerchantGoodsClassification(@RequestParam(name="code", required=false) String var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="status", required=false) String var3, @RequestParam(name="limit", defaultValue="20") Integer var4, @RequestParam(name="page", defaultValue="1") Integer var5);

    @PostMapping(value={"/api/merchant/goods/classification/saveOrUpdate"})
    public Response saveOrUpdateMerchantGoodsClassification(@RequestBody MerchantGoodsClassification var1);

    @GetMapping(value={"/api/merchant/goods/classification/getOpenTree"})
    public Response<List<TreeDto<MerchantGoodsClassification>>> getOpenTree();

    @GetMapping(value={"/api/merchant/goods/classification/openListByGoodsClassificationCode"})
    public Response<List<MerchantGoodsClassification>> openListByGoodsClassificationCode(@RequestParam(value="goodsClassificationCode") String var1);

    @GetMapping(value={"/api/merchant/goodsstock/queryPage"})
    public PageTable<MerchantGoodsStock> merchantGoodsStockPageTable(@SpringQueryMap GoodsStockPageRequestDto var1);

    @GetMapping(value={"/api/merchant/goodsstock/getFullInfoByGoodsCode"})
    public Response<MerchantGoodsStock> getFullInfoByGoodsCode(@RequestParam(value="goodsCode") String var1);

    @PostMapping(value={"/api/merchant/goodsstock/adjustStock"})
    public Response adjustStock(@RequestBody GoodsStockAdminAdjustRequestDto var1);

    @GetMapping(value={"/api/merchant/goodsstocklog/queryPage"})
    public PageTable<MerchantGoodsStockLog> merchantGoodsStockLogPageTable(@RequestParam(value="goodsCode", required=false) String var1, @RequestParam(value="limit", defaultValue="20") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/merchant/supplier/supplierList"})
    public Response<List<MerchantSupplier>> merchantSupplierList();

    @PostMapping(value={"/api/merchant/goodsstock/orderStockOccupied"})
    public Response orderStockOccupied(@RequestBody OrderStockRequestDTO var1);

    @PostMapping(value={"/api/merchant/goodsstock/orderStockReduce"})
    public Response orderStockOut(@RequestBody OrderStockRequestDTO var1);

    @PostMapping(value={"/api/merchant/goodsstock/orderStockCancel"})
    public Response orderStockCancel(@RequestBody OrderStockRequestDTO var1);

    @PostMapping(value={"/api/merchant/goodsstock/orderVCardSend"})
    public Response orderVCardSend(@RequestBody OrderStockRequestDTO var1);

    @GetMapping(value={"/api/merchant/goodsstock/getVCardByOrderNo"})
    public Response<List<OrderVCardResponseItem>> getVCardByOrderNo(@RequestParam(value="orderNo") String var1);

    @PostMapping(value={"/api/merchant/goodsvcardstock/queryPage"})
    public PageTable<MerchantGoodsVCardStock> merchantGoodsVCardStockPageTable(@RequestBody GoodsVcardStockPageRequestDto var1);

    @PostMapping(value={"/api/merchant/goodsvcardstock/importBatchVCard"})
    public Response<Integer> importBatchVCard(@RequestBody List<MerchantGoodsVCardStock> var1);

    @PostMapping(value={"/api/merchant/goods/getSupplierInventedGoodsCodeList"})
    public Response<List<String>> getSupplierInventedGoodsCodeList(@RequestBody List<String> var1);

    @PostMapping(value={"/api/merchant/goodsvcardstock/setVCardToVoid"})
    public Response setVCardToVoid(@RequestBody VCardToVoidRequestDTO var1);

    @GetMapping(value={"/api/merchant/goodsvcardstock/updateVCardExpireTask"})
    public Response updateVCardExpireTask();

    @PostMapping(value={"/api/merchant/goodsstock/orderBatchStockOccupied"})
    public Response orderBatchStockOccupied(@RequestBody @Validated OrderBatchStockRequestDto var1);

    @PostMapping(value={"/api/merchant/goodsstock/orderBatchStockReduce"})
    public Response orderBatchStockReduce(@RequestBody @Validated OrderBatchStockRequestDto var1);

    @PostMapping(value={"/api/merchant/goodsstock/orderBatchStockCancel"})
    public Response orderBatchStockCancel(@RequestBody @Validated OrderBatchStockRequestDto var1);

    @PostMapping(value={"/api/merchant/goodsstock/orderBatchVCardSend"})
    public Response orderBatchVCardSend(@RequestBody @Validated OrderBatchStockRequestDto var1);

    @PostMapping(value={"/api/merchant/merchant-identity"})
    public Response saveOrUpdateMerchantIdentity(@RequestBody MerchantStoreAccountIdentity var1);

    @GetMapping(value={"/api/merchant/merchant-identity/list"})
    public Response<List<MerchantStoreAccountIdentity>> listMerchantStoreIdentity(@RequestParam(value="storeAccountCode", required=false) String var1, @RequestParam(value="identityTypeCode", required=false) String var2);

    @PostMapping(value={"/api/merchant/goodsstock/orderBatchStockRepeatOccupied"})
    public Response orderBatchStockRepeatOccupied(OrderBatchStockRequestDto var1);

    @PostMapping(value={"/api/merchant/goodsstock/merchantGoodsSellableStock"})
    public Response<List<MerchantGoodsStock>> merchantGoodsSellableStock(@RequestBody List<String> var1);

    @GetMapping(value={"/api/merchant/label"})
    public PageTable<MerchantLabel> searchLabel(@RequestParam(name="code", required=false) String var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="status", required=false) String var3, @RequestParam(name="limit", defaultValue="20") int var4, @RequestParam(name="page", defaultValue="1") int var5);

    @PostMapping(value={"/api/merchant/label/saveOrUpdateLabel"})
    public Response saveOrUpdateLabel(@RequestBody MerchantLabel var1);

    @GetMapping(value={"/api/merchant/label/switchStatus"})
    public Response switchStatus(@RequestParam(name="id") Integer var1, @RequestParam(name="status") String var2);

    @GetMapping(value={"/api/merchant/label/{id}/get"})
    public Response getById(@PathVariable(value="id") Integer var1);

    @PostMapping(value={"/api/merchant/label/findLabelByCodes"})
    public Response<List<MerchantLabel>> findLabelByCodes(@RequestBody LabelSearchParam var1);

    @GetMapping(value={"/api/merchant/label/findGoodsLabelByLabelCode"})
    public Response<List<MerchantGoodsLabel>> findGoodsLabelByLabelCode(@RequestParam(name="labelCode") String var1);

    @GetMapping(value={"/api/merchant/label/deleteGoodsLabel"})
    public Response deleteGoodsLabelById(@RequestParam(name="id") Integer var1);

    @PostMapping(value={"/api/merchant/label/saveGoodsLabels"})
    public Response saveGoodsLabels(@RequestBody GoodsLabelParam var1);

    @GetMapping(value={"/api/merchant/supplier/supplierWarehouse"})
    public Response<MerchantSupplierWarehouse> merchantSupplierWarehouse(@RequestParam(value="supplierCode") String var1);
}

