package com.rocogz.merchant.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 商品sku销售属性名元数据
 * </p>
 *
 * @author zhangmin
 * @since 2020-10-26
 */
@Setter @Getter @Accessors(chain = true)
public class MerchantSkuAttr extends IdEntity {
    /**
     * 商品编码
     */
    private String productCode;

    /**
     * 销售属性编号,系统自动生成
     */
    private String attrCode;

    /**
     * 销售属性名：例如：颜色
     */
    private String attrName;

    /**
     * 显示顺序
     */
    private Integer seq;


    //非PO属性,前端页 提交过来的属性值,例如：[白色,红色,绿色]
    @TableField(exist = false)
    private List<String> attrValueList;

}
