package com.rocogz.merchant.entity.goods;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 商品sku销售属性值
 * </p>
 *
 * @author zhangmin
 * @since 2020-10-26
 */
@Setter
@Getter
@Accessors(chain = true)
public class MerchantSkuAttrValue extends IdEntity implements Comparable<MerchantSkuAttrValue> {

    /**
     * sku编号
     */
    private String skuCode;

    /**
     * 销售属性编号
     *
     * @see MerchantSkuAttr#attrCode
     */
    private String attrCode;

    /**
     * 属性名
     */
    private String attrName;

    /**
     * 白色
     */
    private String attrValue;

    /**
     * 销售属性值显示排序位置
     */
    private Integer seq;

    @Override
    public int compareTo(MerchantSkuAttrValue other) {
        int result = this.seq.compareTo(other.seq);
        if (result == 0) {
            result = this.getId().compareTo(other.getId());
        }
        return result;
    }

}
