package com.rocogz.merchant.dto.goods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.merchant.constant.MerchantGoodsConstant;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 后台管理 搜索商品参数Dto
 * @author zhangmin
 * @date 2020/6/15
 */
@Data
public class AdminSearchProductParamDto {

    /**
     * 商品编号
     */
    private String productCode;

    /**
     * 商品名称
     */
    private String productName;

    /**
     * 商品分类编号
     */
    private String classifyCode;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 品牌编码
     */
    private String brandCode;

    /**
     * 商品支付方式：纯积分、现金抵扣积分、固定积分+固定现金
     * @see MerchantGoodsConstant.DictProductPayWay
     */
    private String payWay;


    /**
     * 要排查的商品状态列表
     */
    private List<String> excludeStatusList;

    /**
     * 商品状态
     */
    private String status;

    /**
     * 是否虚拟商品
     */
    private Boolean virtual;

    /**
     * 虚拟商品类型：卡券、充值、碎屏险、 电池券/换壳券
     * @see MerchantGoodsConstant.DictVirtualProductType
     */
    private String virtualType;

    /**
     * 需要排除的skuCode列表
     */
    private List<String> excludeSkuCodeList;

    /**
     * 供应商编码
     */
    private List<String> supplierCodeList;

    private Integer limit = 20;

    private Integer page = 1;

    @JsonIgnore
    public String getLikeProductName() {
        if(StringUtils.isEmpty(productName)) {
            return null;
        }

        return "%" + productName + "%";
    }


    @JsonIgnore
    public String getLikeProductCode() {
        if(StringUtils.isEmpty(productCode)) {
            return null;
        }

        return "%" + productCode + "%";
    }
}
