package com.rocogz.merchant.constant;

/**
 * 商户商品相关的常量
 * @author zhangmin
 * @date 2020/10/23
 */
public class MerchantGoodsConstant {

    /**
     * 现金与积分的兑换比例,兑换系数 1元=100积分
     */
    public static final int  EXCHANGE_COEFFICIENT = 100;

    /**
     * 新增商品时：前端提交的默认商品编号
     */
    public static final String DEFAULT_PRODUCT_CODE = "defaultProductCode";


    /**
     * 系统内置sku:手机延保服务(线上)
     */
    public static final String EMBED_EXTENSION_INSURANCE_SKU = "SP000000325501";

    /**
     * 系统内置sku:碎屏险(线上)
     */
    public static final String SCREEN_CRASH_INSURANCE_SKU = "SP000000325401";

    /**
     * 系统内置sku:碎屏险(线下)
     */
    public static final String SCREEN_CRASH_INSURANCE_OFFLINE_SKU = "SP000000325601";



    /**
     * 商品订单支付方式
     */
    public static class DictProductPayWay {
        //字典类型编号
        public static final String TYPE_CODE = "PRODUCT_PAY_WAY";

        //=== 下面是字典值

        //纯积分
        public static final String CENT = "CENT";

        //现金抵扣积分
        public static final String CASH_DEDUCTION = "CASH_DEDUCTION";

        //固定积分+现金
        public static final String CENT_WITH_CASH = "CENT_WITH_CASH";

    }

    /**
     * 商品状态
     */
    public static class DictProductStatus {
        //字典类型编号
        public static final String TYPE_CODE = "PRODUCT_STATUS";

        //=== 下面是字典值

        //现金抵扣积分、固定积分+固定现金

        //草稿
        public static final String DRAFT = "DRAFT";

        //待审批
        public static final String PENDING_APPROVE = "PENDING_APPROVE";

        //待上架
        public static final String PENDING_LIST = "PENDING_LIST";

        //审批不通过
        public static final String REFUSE = "REFUSE";

        //已上架
        public static final String LIST = "LIST";

        //已下架
        public static final String DELIST = "DELIST";

        //作废
        public static final String INVALID = "INVALID";

    }

    /**
     * 虚拟商品类型
     */
    public static class DictVirtualProductType {

        //字典类型编号
        public static final String TYPE_CODE = "VIRTUAL_GOOD_TYPE";

        //=== 下面是字典值
        //现金抵扣积分、固定积分+固定现金

        //卡券/卡密
        public static final String CARD = "CARD";

        //充值
        public static final String DEPOSIT = "DEPOSIT";

        //换壳券
        public static final String COUPON = "COUPON";

        //电池券
        public static final String BATTERY_COUPON = "BATTERY_COUPON";


        //下面2种虚拟商品，是系统内置的虚拟商品,不在三星积分商城展示
        //手机延保服务
        public static final String EXTENSION_INSURANCE= "EXTENSION_INSURANCE";

        //碎屏险
        public static final String SCREEN_CRASH_INSURANCE = "SCREEN_CRASH_INSURANCE";
    }


    /**
     * 三星管家服务商品 手机类型
     */
    public static class DictMobileType {
        //字典类型编号
        public static final String TYPE_CODE = "SAMSUNG_MOBILE_TYPE";
    }


    /**
     * 三星手机助手App coupon码 对应的 手机型号
     */
    public static class DictSamsungMobileModel {
        //字典类型编号
        public static final String TYPE_CODE = "SAMSUNG_APP_MOBILE_MODEL";
    }

}
