package com.rocogz.merchant.dto.goodsStock;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>Description:这家伙很懒 </dd>
 * <dd>@date: 2020/11/07</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Getter
@Setter
public class OrderStockOccupyRequestDto extends OrderStockRequestBaseDto {

    /**
     * 订单商品
     */
    private List<OrderProduct> productList;

    /**
     * 订单商品
     */
    @Getter
    @Setter
    @Accessors(chain = true)
    public static class OrderProduct {
        /**
         * 购买商品的SKU编码/套餐的主商品sku编码
         */
        private String skuCode;
        /**
         * 商品类型
         */
        private ProTypeEnum proType;
        /**
         * 购买数量
         */
        private Integer buyNum;
        /**
         * 占用请求
         */
        private List<OccupyItem>  occupyItemList;
    }

    /**
     * 占用
     */
    @Getter
    @Setter
    @Accessors(chain = true)
    public static class  OccupyItem  {
        /**
         * 子订单号
         */
        private String subOrderCode;
        /**
         * 占用库存的SKU编码
         */
        private String skuCode;
        /**
         * 购买一个商品时，需要占用的数量，不要进行乘购买数量。
         */
        private Integer occupyNum;

    }

    /**
     * 商品类型
     */
    public  enum ProTypeEnum {

        //GENERAL：普通 SUITE:套餐

        GENERAL, SUITE
    }


}
