package com.rocogz.merchant.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.constant.MerchantGoodsConstant;
import com.rocogz.merchant.entity.attechment.MerchantAttechment;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.merchant.entity.supplier.MerchantSupplier;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 商品基本信息表
 * </p>
 *
 * @author zhangmin
 * @since 2020-06-16
 */
@Setter
@Getter
@Accessors(chain = true)
public class MerchantGoods extends UserTimeEntity {

    /**
     * 商品编码
     */
    private String code;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 类型：普通商品、福袋商品
     * {@link MerchantGoodsConstant.MerchantGoodsType}
     */
    private String type;

    /**
     * 商品分类编码
     */
    private String classifyCode;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 品牌编码
     */
    private String brandCode;

    /**
     * 是否虚拟商品
     */
    private Boolean virtual;

    /**
     * 是否三星专区商品
     */
    private Boolean samsungPrefecture;

    /**
     * 虚拟商品类型：卡券、充值、碎屏险、 电池券、换壳券
     *
     * @see MerchantGoodsConstant.DictVirtualProductType
     */
    private String virtualType;


    /**
     * 列表图:路径可能会被分割成几个对应比列的图
     */
    private String listImgUrl;

    /**
     * 搜索关键字
     */
    private String keyword;

    /**
     * 商品支付方式：纯积分、现金抵扣积分、固定积分+固定现金
     *
     * @see MerchantGoodsConstant.DictProductPayWay
     */
    private String payWay;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 运营服务费率
     */
    private BigDecimal operationServiceRate;

    /**
     * 是否支持花呗分期
     */
    private Boolean pcreditSupported;

    /**
     * 是否管家专项服务
     */
    private Boolean butlerService;

    /**
     * 手机产品系列（管家服务商品专属字段）
     * 例如："Galaxy Z Flip","Galaxy S8系列","Galaxy S10系列"
     */
    private String mobileSeries;

    /**
     * 到货通知消息
     */
    private String notice;

    /**
     * 是否有销售规格属性
     */
    private Boolean hasSku;

    /**
     * 是否需要排序,如果需要排序，则加入有排序值分组
     */
    private Boolean hasSeq;

    /**
     * 显示排序位置值
     */
    private Integer seq;

    /**
     * 商品状态
     *
     * @see MerchantGoodsConstant.DictProductStatus
     */
    private String status;

    /**
     * 初始化良品库存
     */
    private Integer initStock;

    /**
     * 第三方充值业务类型，eg: FULU
     */
    private String chargeBizType;

    /**
     * 第三方充值业务类型名称，eg：福禄
     */
    private String chargeBizTypeName;

    /**
     * 第三方充值商品id
     */
    private String chargeProductId;

    /**
     * 第三方充值商品名称
     */
    private String chargeProductName;

    /**
     * 原始商品的编码，针对copy出来的商品，用来保存关联关系
     */
    private String originalCode;

    /**
     * 商品详情介绍
     */
    private String detail;

    /**
     * 发票税点
     */
    private BigDecimal taxRate;

    /**
     * 实物商品物流费
     */
    private BigDecimal logisticFee;


    /**
     * 是否是系统内置商品
     */
    public boolean isEmbedProduct() {
        return MerchantGoodsConstant.DictVirtualProductType.EXTENSION_INSURANCE.equals(virtualType) ||
                MerchantGoodsConstant.DictVirtualProductType.RENEW_INSURANCE.equals(virtualType) ||
                MerchantGoodsConstant.DictVirtualProductType.SCREEN_CRASH_INSURANCE.equals(virtualType);
    }


    //========> 以下是非持久化属性

    @TableField(exist = false)
    private List<MerchantGoodsLabel> labelList;

    @TableField(exist = false)
    private List<MerchantSkuAttr> skuAttrList;

    @TableField(exist = false)
    private List<MerchantSku> skuList;


    //前端商品详情页,停用的sku属性值组合列表
    @TableField(exist = false)
    private List<String> lockSkuAttrValuesList;

    /**
     * 详情图片列表
     */
    @TableField(exist = false)
    private List<MerchantAttechment> detailImages;

    /**
     * 品牌对象
     */
    @TableField(exist = false)
    private MerchantBrand brand;

    /**
     * 供应商对象
     */
    @TableField(exist = false)
    private MerchantSupplier supplier;

    /**
     * 商品分类对象
     */
    @TableField(exist = false)
    private MerchantGoodsClassification classify;

    /**
     * 限兑条件
     */
    @TableField(exist = false)
    private List<MerchantGoodsLimit> limits;

    /**
     * 操作日志
     */
    @TableField(exist = false)
    private List<MerchantGoodsLog> logList;

    /**
     * 福袋商品中关联的普通商品信息
     */
    @TableField(exist = false)
    private List<MerchantSuiteSku> suiteSkus;

    /**
     * 是否可以选择sku，针对福袋类型的商品。
     * <br/>
     * 如果有待出库的订单，编辑页面不出现选择sku的按钮，和删除sku的按钮，
     * 即可以编辑已有sku的市场价、结算价、积分，但是不能新增或者删除sku
     */
    @TableField(exist = false)
    private Boolean chooseSuiteSkuAvailable = Boolean.TRUE;

    //状态label
    private transient String statusLabel;

    //支付方式label
    private transient String payWayLabel;
}
