package com.rocogz.merchant.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>
 * 商品sku表
 * </p>
 *
 * @author zhangmin
 * @since 2020-10-23
 */
@Setter
@Getter
@Accessors(chain = true)
public class MerchantSku extends IdEntity {

    /**
     * 商品编码
     */
    private String productCode;

    /**
     * sku编号
     */
    private String skuCode;

    /**
     * sku商品名
     */
    private String skuName;

    /**
     * sku图片
     */
    private String skuImgUrl;

    /**
     * 状态：启用/停用
     *
     * @see Constant.DictData#COMMON_STATUS_OPEN
     */
    private String status;

    /**
     * 结算价
     */
    private BigDecimal settlementPrice;

    /**
     * 积分价
     * （1）"纯积分"支付方式：纯积分
     * （2）"现金抵扣兑换"支付方式：总积分
     * （3）"固定积分+固定现金"支付方式： 固定积分
     */
    private BigDecimal cent;

    /**
     * 最少积分,"现金抵扣兑换"支付方式下：需支付的最少积分
     */
    private BigDecimal minCent;

    /**
     * 现金价(元)
     * "固定积分+固定现金" 支付方式下，固定现金
     */
    private BigDecimal cash;

    /**
     * sku排序位置值
     */
    private Integer seq;

    /**
     * 原始sku的编码，针对copy出来的sku，用来保存关联关系
     */
    private String originalSkuCode;

    /**
     * ERP编码
     */
    private String erpCode;

    //======== 以下是非PO属性
    //可用库存数
    private transient Integer availableStock;
    //前端页面显示的 管家专享价,只有管家专项服务商品才显示 管家专享价
    private transient BigDecimal butlerPrice;

    @TableField(exist = false)
    private MerchantGoods product;

    //当前sku的属性值
    @TableField(exist = false)
    private List<MerchantSkuAttrValue> attrValueList;

    //获得页面显示的销售属性值,例如： 白色,XL,500G
    public String getSaleAttrValues() {
        if (CollectionUtils.isEmpty(attrValueList)) {
            return StringUtils.EMPTY;
        }
        Collections.sort(attrValueList);
        return attrValueList.stream().map(MerchantSkuAttrValue::getAttrValue).collect(Collectors.joining(","));
    }


    /**
     * 获得前端显示的sku图片,如果有上传了sku图片,则用sku图片，否则显示商品图片
     *
     * @return
     */
    public String getPreviewSkuImg() {
        if (StringUtils.isNotBlank(skuImgUrl)) {
            return skuImgUrl;
        } else if (product != null) {
            return product.getListImgUrl();
        } else {
            return StringUtils.EMPTY;
        }
    }

    /**
     * 获取总积分
     * （1）"纯积分"支付方式：纯积分
     * （2）"现金抵扣兑换"支付方式：总积分
     * （3）"固定积分+固定现金"支付方式： 固定积分 + 固定现金*100
     *
     * @return
     */
    public BigDecimal getTotalCent() {
        return Optional.ofNullable(getCent()).orElse(BigDecimal.ZERO)
                .add(Optional.ofNullable(getCash()).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(100)));
    }
}
