package com.rocogz.merchant.entity.supplier;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 供应商
 * </p>
 *
 * @author huhl
 * @since 2020-06-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("merchant_supplier_warehouse")
public class MerchantSupplierWarehouse extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 仓库联系人
     */
    private String contact;

    /**
     * 仓库电话
     */
    private String tel;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区名称
     */
    private String districtName;

    /**
     * 区编码
     */
    private String districtCode;

    /**
     * 街道名称
     */
    private String streetName;

    /**
     * 街道编码
     */
    private String streetCode;

    /**
     * 详细地址
     */
    private String detailAddress;


}
