package com.rocogz.merchant.entity.goods;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:业务单据数据的日志记录操作 </dd>
 * <dd>@date: 2020/08/22</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
@TableName(value = "merchant_goods_stock_business_log")
public class MerchantGoodsStockBusinessLog  extends UserTimeEntity {

    private static final long serialVersionUID = 1L;
    /**
     *  业务系统的 订单编号 获取 其他的单据类型号
     */
    public String docNo;
    /**
     * 单据的类型：订单，....
     */
    public String docType;
    /**
     * 商品编码
     */
    public String goodsCode;

    /**
     *
     * 占用库存数量
     */
    public Integer occupiedNum;

    /**
     * 已出库数量
     */
    public Integer outNum;

    /**
     *取消数量，目前只有订单超时/用户主动取消的，全部取消不支持部分
     */
    public Integer cancelNum;

    /**
     * 占用库存时间
     */
    public LocalDateTime occupiedTime;

    /**
     * 出库时间
     */
    public LocalDateTime outTime;

    /**
     * 取消时间
     */
    public LocalDateTime cancelTime;



}
