package com.rocogz.merchant.dto.goods;

import com.rocogz.merchant.pager.Sort;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <dl>
 * <dd>Description:库存分页查询请求参数</dd>
 * <dd>@date: 2020/08/14</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class GoodsStockPageRequestDto {

    /**
     * 商品编码 查的是商品编码
     */
    private String goodsCode;

    /**
     * 查询的商品SKU编码
     */
    private String skuCode;

    /**
     * 商品名称，查询的是SKU名称
     */
    private String goodsName;
    /**
     * 品牌编码
     */
    private String brandCode;
    /**
     * 商品分类编码
     */
    private String goodsClassificationCode;
    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 供应商编码集合
     */
    private List<String> supplierCodeList;

    /**
     * 是否导出
     */
    private Boolean export=Boolean.FALSE;

    /**
     * 商品状态
     */
    private String productStatus;

    /**
     * 是否展示预警库存
     */
    private Boolean showWarnStock;

    /**
     * 排序方向
     */
    private String direction;

    /**
     * 排序字段
     */
    private String orderBy;

    /**
     * 排序
     */
    private Sort sort;

    /**
     *  每页多少条
     */
    private int limit;
    /**
     * 第几页
     */
    private int page;
}
