package com.rocogz.merchant.dto.goodsStock;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.List;

/**
 * <dl>
 * <dd>Description:套餐商品项,增加/删除时同步调整库存 </dd>
 * <dd>@date: 2021/01/22</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Getter
@Setter
@Accessors(chain = true)
public class GoodsSuiteItemModifyStockParamDto {


    public GoodsSuiteItemModifyStockParamDto(){
        suitItems=new ArrayList<>();
    }
    /**
     * 套餐SKU
     */
    private String suitSkuCode;
    /**
     * 套餐的Item
     */
    private List<SuiteItem> suitItems;
    /**
     * 创建人
     */
    private String createUser;

    /**
     * 添加子项
     * @param skuCode 套餐Item的skuCode
     * @param opType 操作类型
     * @param num Item的组成数量 默认填写1
     */
    public void addSuiteItem(String skuCode,OpType opType,Integer num){
        SuiteItem item = new SuiteItem().setSkuCode(skuCode)
                .setNum(num)
                .setOpType(opType);
        suitItems.add(item);
    }

    @Getter
    @Setter
    @Accessors(chain = true)
    public class SuiteItem {
        /**
         * 子的SKU
         */
        private String skuCode;
        /**
         * 组成套餐的Item数量
         */
        private Integer num=1;
        /**
         * 操作类型
         */
        private OpType opType;
    }

    /**
     * 操作类型：新增还是删除
     */
    public enum OpType {
        NEW, DELETE
    }
}
