package com.rocogz.merchant.entity.identity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 商户中心-用户身份
 * </p>
 *
 * @author yinshihao
 * @since 2020-09-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("merchant_store_account_identity")
public class MerchantStoreAccountIdentity extends UserTimeEntity {

    private static final long serialVersionUID = -8267497017345338789L;
    /**
     * 门店账号编号
     */
    private String storeAccountCode;

    /**
     * 用户openid
     */
    private String userWxOpenid;

    /**
     * 用户手机号
     */
    private String userMobile;

    /**
     * 身份来源(CAR_OWNER:车服; OIL:油卡;PICC:人保)
     */
    private String identitySource;

    /**
     * 身份类型编码
     */
    private String identityTypeCode;

    /**
     * 身份编码
     */
    private String identityCode;

    /**
     * 状态
     */
    private String status;

    /**
     * 图标url
     */
    private String iconUrl;

    /**
     * 备注
     */
    private String remark;

    /**
     * 生效时间
     */
    private LocalDateTime effectiveTime;

    /**
     * 失效时间
     */
    private LocalDateTime expirationTime;

}
