package com.rocogz.merchant.constant;

/**
 * 常量
 * @author：liangyongtong
 * @since：2020/4/6
 */
public final class Constant {

    public final static String MERCHANT_SERVICE_NAME = "merchant-base-service";

    /**
     * 字典表类型
     */
    public class DictType {
        /** 商户状态 */
        public final static String MERCHANT_STORE_STATUS = "MERCHANT_STORE_STATUS";
        /** 评价维度 */
        public final static String EVALUATIVE_DIMENSION = "EVALUATIVE_DIMENSION";
        /** 商户后台库存调整类型 目前有 增加，减少，预警库存，将来可能有库存占用，占用取消，库存还原等 */
        public final static String MERCHANT_GOODS_STOCK_OPERATE_TYPE = "MERCHANT_GOODS_STOCK_OPERATE_TYPE";

        /** 商户后台库存调整类型 目前有 增加，减少，预警库存，将来可能有库存占用，占用取消，库存还原等 */
        public final static String OPPOINTROLE = "OPPOINTROLE";

        /** 虚拟卡券状态*/
        public final static String MERCHANT_GOODS_VCARD_STATUS="MERCHANT_GOODS_VCARD_STATUS";
        /** 虚拟卡券类型*/
        public final static String MERCHANT_GOODS_VCARD_TYPE="MERCHANT_GOODS_VCARD_TYPE";

        /** 礼品选择过滤系数设置 */
        public final static String GIFT_FILTER_COEFFICENT = "GIFT_FILTER_COEFFICENT";
    }

    /**
     * 字典表数据
     */
    public class DictData {
        /** 投保礼 上架状态 */
        public final static String MERCHANT_TOTAL_STATUS_UP_LIST = "UP_LIST";
        public final static String MERCHANT_TOTAL_STATUS_UP_LIST_LABEL = "上架";
        /** 投保礼 下架状态 */
        public final static String MERCHANT_TOTAL_STATUS_DOWN_LIST = "DOWN_LIST";
        public final static String MERCHANT_TOTAL_STATUS_DOWN_LIST_LABEL = "下架";
        /** 投保礼 待上架状态 */
        public final static String MERCHANT_TOTAL_STATUS_STAYINGON = "STAYINGON";
        public final static String MERCHANT_TOTAL_STATUS_STAYINGON_LABEL = "待上架";


        /** 商户/服务/商品 草稿状态 */
        public final static String MERCHANT_STORE_STATUS_DRAFT = "DRAFT";
        public final static String MERCHANT_STORE_STATUS_DRAFT_LABEL = "新增";

        /** 商户/服务/商品 待审批 */
        public final static String MERCHANT_STORE_STATUS_PENDING = "PENDING";
        public final static String MERCHANT_STORE_STATUS_PENDING_LABEL = "待审批";

        /** 商户/服务/商品 审批不通过 */
        public final static String MERCHANT_STORE_STATUS_REFUSE = "REFUSE";
        public final static String MERCHANT_STORE_STATUS_REFUSE_LABEL = "审批不通过";

        /** 商户/服务/商品 审批通过 */
        public final static String MERCHANT_STORE_STATUS_PASS_LABEL = "审批通过";

        /** 商户/服务/商品 待上架状态 */
        public final static String MERCHANT_STORE_STATUS_STAYINGON = "STAYINGON";
        public final static String MERCHANT_STORE_STATUS_STAYINGON_LABEL = "提交审批";

        /** 商户/服务/商品 上架状态 */
        public final static String MERCHANT_STORE_STATUS_UP_LIST = "UP_LIST";
        public final static String MERCHANT_STORE_STATUS_UP_LIST_LABEL = "上架";


        /** 商户/服务/商品 下架状态 */
        public final static String MERCHANT_STORE_STATUS_DOWN_LIST = "DOWN_LIST";
        public final static String MERCHANT_STORE_STATUS_DOWN_LIST_LABEL = "下架";
        /** 商户/服务/商品 作废状态 */
        public final static String MERCHANT_STORE_STATUS_INVALID = "INVALID";
        public final static String MERCHANT_STORE_STATUS_INVALID_LABEL = "作废";

        /** 兑换商品 待上架状态 */
        public final static String EXCHANGE_GOODS_STATUS_WAIT_UP_LIST = "WAIT_UP_LIST";
        public final static String EXCHANGE_GOODS_STATUS_WAIT_UP_LIST_LABEL = "待上架";
        /** 商户服务车型：不区分车型 */
        public final static String AREA_SERVICE_CAR_TYPE_ALL = "ALL";
        public final static String AREA_SERVICE_CAR_TYPE_ALL_LABEL = "不区分车型";
        /** 商户服务小型车 */
        public final static String AREA_SERVICE_CAR_TYPE_CAR = "CAR";

        /** 停业类型：日期段 */
        public final static String MERCHANT_STORE_BUSINESS_TYPE_DATE_SECTION = "DATE_SECTION";
        public final static String MERCHANT_STORE_BUSINESS_TYPE_DATE_SECTION_LABEL = "指定日期段";
        /** 停业类型：周几 */
        public final static String MERCHANT_STORE_BUSINESS_TYPE_WEEKS = "WEEKS";
        public final static String MERCHANT_STORE_BUSINESS_TYPE_WEEKS_LABEL = "每周几";
        /** 停业类型：每月几号 */
        public final static String MERCHANT_STORE_BUSINESS_TYPE_DAYS = "DAYS";
        public final static String MERCHANT_STORE_BUSINESS_TYPE_DAYS_LABEL = "每月几号";
        /** 公共的状态 启用 */
        public final static String COMMON_STATUS_OPEN = "OPEN";
        /** 公共的状态 停用 */
        public final static String COMMON_STATUS_LOCK = "LOCK";
        /** 公共的状态 是 */
        public final static String COMMON_STATUS_YES = "Y";
        /** 公共的状态 否 */
        public final static String COMMON_STATUS_NO = "N";
        /** 专区服务项目范围 */
        public final static String AREA_SERVICE_RANGE_ALL = "AREA_SERVICE_RANGE_ALL";



        /** 供应商 新增/修改 */
        public final static String MERCHANT_SUPPLIER_CREATE_LABEL = "新增";
        public final static String MERCHANT_SUPPLIER_UPDATE_LABEL = "修改";

        /** 供应商 合作 */
        public final static String MERCHANT_SUPPLIER_STATUS_COOPERATION = "COOPERATION";
        public final static String MERCHANT_SUPPLIER_STATUS_COOPERATION_LABEL = "合作";

        /** 供应商 已作废 */
        public final static String MERCHANT_SUPPLIER_STATUS_DELETE = "DELETE";
        public final static String MERCHANT_SUPPLIER_STATUS_DELETE_LABEL = "已作废";

        /** 供应商 已中止 */
        public final static String MERCHANT_SUPPLIER_STATUS_STOP = "STOP";
        public final static String MERCHANT_SUPPLIER_STATUS_STOP_LABEL = "已中止";


        /**
         * 预警库存调整，但不出出现在字典数据中
         */
        public final static String MERCHANT_GOODS_STOCK_OPERATE_WARN="WARN" ;
        public final static String MERCHANT_GOODS_STOCK_OPERATE_WARN_LABEL="调整预警库存" ;

        /**
         * 后台的增加库存调整，出现在字典数据中
         */
        public final static String MERCHANT_GOODS_STOCK_OPERATE_ADD_STOCK="ADD_STOCK" ;
        public final static String MERCHANT_GOODS_STOCK_OPERATE_ADD_STOCK_LABEL="增加良品库存" ;

        /**
         * 后台减少库存调整，出现在字典数据中
         */
        public final static String MERCHANT_GOODS_STOCK_OPERATE_REDUCE_STOCK="REDUCE_STOCK" ;
        public final static String MERCHANT_GOODS_STOCK_OPERATE_REDUCE_STOCK_LABEL="减少良品库存" ;



        /**
         * 预警库存调整，但不出出现在字典数据中
         */
        public final static String MERCHANT_GOODS_STOCK_OPERATE_OCCUPIED="occupied" ;
        public final static String MERCHANT_GOODS_STOCK_OPERATE_OCCUPIED_LABEL="调整占用库存" ;




        /** 虚拟卡的卡密类型 */
        public final static String VCARD_CARDTYPE_CARD="CARD";//卡号密码
        public final static String VCARD_CARDTYPE_PASSWORD="PASSWORD";//卡密
        public final static String VCARD_CARDTYPE_EXCHANGE="EXCHANGE";//兑换码
        public final static String VCARD_CARDTYPE_URL="URL";//URL,三星老订单数据



        /** 虚拟卡状态 */
        public final static String VCARD_STATUS_NOT_USED="NOT_USED";//未使用
        public final static String VCARD_STATUS_USED="USED";//已使用
        public final static String VCARD_STATUS_EXPIRED="EXPIRED";//已过期
        public final static String VCARD_STATUS_TO_VOID="TO_VOID";//已作废

        // 设保礼礼品类型
        /** 组合套餐 **/
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_PACKAGE = "PACKAGE";
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_PACKAGE_LABEL = "组合套餐";
        /** 项目 */
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_PROJECT = "PROJECT";
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_PROJECT_LABEL = "项目";
        /** 商品 */
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_GOODS = "GOODS";
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_GOODS_LABEL = "商品";
        /** 代金券 */
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_COUPON = "COUPON";
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_COUPON_LABEL = "代金券";

        /** 代金券 */
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_CASH = "CASH";
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_CASH_LABEL = "现金";

        // 礼品选择过滤系数设置
        /** 成本系数 */
        public final static String GIFT_FILTER_COEFFICENT_COST_COEFFICENT = "COST_COEFFICENT";
        /** 膨胀系数 */
        public final static String GIFT_FILTER_COEFFICENT_INFLATION_COEFFICENT = "INFLATION_COEFFICENT";
        /** 预算价格系数  */
        public static final String GIFT_FILTER_COEFFICENT_REMAIN_PRICE_COEFFICENT = "REMAIN_PRICE_COEFFICENT";

        /** 商品类型-ROCO特惠商城 */
        public final static String ROCO_SPECIAL_MALL = "ROCO_SPECIAL_MALL";
    }

    /**
     * 普通常量
     */
    public class General {
        /** 商户停业项提示内容 */
        public final static String MERCHANT_STORE_STOP_BUSINESS_LABEL = "停业";
        /** 商户修改项提示内容 */
        public final static String MERCHANT_STORE_OPERATE_LABEL = "修改";
        /** 商户标签:基本信息 */
        public final static String MERCHANT_STORE_UPDATE_TAB_BASE = "基本信息";
        /** 商户标签:营业信息 */
        public final static String MERCHANT_STORE_UPDATE_TAB_BUSINESS = "营业信息";
        /** 商户标签:行业信息 */
        public final static String MERCHANT_STORE_UPDATE_TAB_INDUSTRY = "行业信息";
        /** 商户标签:账号信息 */
        public final static String MERCHANT_STORE_UPDATE_TAB_ACCOUNT = "账号信息";
        /** 商户标签:结算信息 */
        public final static String MERCHANT_STORE_UPDATE_TAB_SETTLE = "结算信息";

        /** 设置为精选评价 */
        public final static String MERCHANTEVALUATEKPI_ADD = "ADD";
        /** 取消精选评价 */
        public final static String MERCHANTEVALUATEKPI_CANCEL = "CANCEL";
        /** 删除 评价 */
        public final static String MERCHANTEVALUATEKPI_DELETE = "DELETE";
        /** 隐藏 评价 */
        public final static String MERCHANTEVALUATEKPI_HIDE = "HIDE";
        /** 显示评价 */
        public final static String MERCHANTEVALUATEKPI_SHOW = "SHOW";

        /**投保礼类型-套餐*/
        public final static String MERCHANGIFTTYPE_PACKAGE = "PACKAGE";
        /**投保礼类型-项目*/
        public final static String MERCHANGIFTTYPE_PROJECT = "PROJECT";
        /**投保礼类型-商品*/
        public final static String MERCHANGIFTTYPE_GOODS = "GOODS";
        /**投保礼类型-代金券*/
        public final static String MERCHANGIFTTYPE_COUPON = "COUPON";


        /**投保礼数据类型-商户端*/
        public final static String MERCHANTSOURCETYPE_MERCHANT="MERCHANT";
        /**投保礼数据类型-车主端*/
        public final static String MERCHANTSOURCETYPE_CAROWNER="CAROWNER";
    }

    /**
     * 发号键值
     */
    public class SerialNo {
        /** 商户编码序列编号 */
        public final static String MERCHANT_STORE_CODE = "MERCHANT_STORE_CODE";
        /** 商户账号编码 */
        public final static String MERCHANT_STORE_ACCOUNT_CODE = "MERCHANT_SA_CODE";
        /** 专区服务项目编码 */
        public final static String AREA_SERVICE_CODE = "AREA_SERVICE_CODE";
        /** 专区服务项目结算价格编码 */
        public final static String AREA_SERVICE_SETTLE_CODE = "AREA_SERVICE_SETTLE_CODE";
        /** 商户服务项目编码 **/
        public final static String STORE_SERVICE_CODE = "STORE_SERVICE_CODE";
        /** 商品编码序列编号 */
        public final static String MERCHANT_GOODS_CODE = "MERCHANT_GOODS_CODE";
        /** 福袋商品编码序列编号 */
        public final static String SUITE_MERCHANT_GOODS_CODE = "SUITE_MERCHANT_GOODS_CODE";
        /** sku编号 */
        public final static String SKU_CODE = "SKU_CODE";
        /** sku属性编号 */
        public final static String SKU_ATTR_CODE = "SKU_ATTR_CODE";

        /** 供应商编码 */
        public final static String MERCHANT_SUPPLIER_CODE = "MERCHANT_SUPPLIER_CODE";
        /** 商户投保礼订单编码 **/
        public final static String MERCHANT_INSURANCE_GIFT_ORDER_CODE = "MERCHANT_INSURANCE_GIFT_ORDER_CODE";
    }

    /**
     * Redis缓存键值
     */
    public class RedisKey {

        /** 车主端推荐的商户缓存开始编码：后面 + 商户编码 作为一个 key */
        public final static String CAR_INDEX_STORE_START = "RECOMMEND:";

        /** 加油站对应商户类型存储的商户编码 */
        public final static String GAS_STATION_TYPE = "GS_TYPE:";
        /** 加油站对应品牌存储的商户编码 */
        public final static String GAS_STATION_BRAND = "GS_BRAND:";
        /** 加油站对应的商户列表（含商户编码，经纬度） */
        public final static String GAS_STATION_LIST = "GS_LIST";

        /**全局锁,虚拟卡占用库存**/
        public final static String VCARD_LOCK_OCC_STOCK="VCARD_LOCK_OCC_STOCK_";

        // ROCO特惠商城代理人信息前缀
        public final static String ROCO_SPECIAL_MALL_AGENT = "ROCO_SPECIAL_MALL_AGENT:";
    }


    /**
     * 商户回调接口配置
     */
    public class MerchantCallback {
        public final static String MERCHANT_STORE_STATUS_UP_LIST_CALLBLACK_INFERFACE = "/api/merchant/store/storeApproveCallBlack";

        public final static String MERCHANT_GOODS_STATUS_UP_LIST_CALLBLACK_INFERFACE = "/api/merchant/goods/goodsApproveCallBlack";
    }

    /**
     * 业务流水业务中的单据类型
     */
    public class MerchantStockBusinessLogDocType{
        /**
         * 订单
         */
        public final  static String  ORDER="ORDER";
    }


    /**
     * 业务系统操作人员，下单，系统主要是取消，库存管理端更新人员展示用
     */
    public class MerchantStockLogBusinessSystemOperator {

        public final static String OPERATOR_SYSTEM="SYSTEM";
        public final static String OPERATOR_SYSTEM_LABEL="系统";

        public final static String OPERATOR_ORDER="ORDER";
        public final static String OPERATOR_ORDER_LABEL="前台交易";



    }




    public class MerchantRabbit {
        /** 商户中心-商品库存 exchange */
        public static final String MERCHANT_GOODS_STOCK_EXCHANGE = "MERCHANT_GOODS_STOCK_EXCHANGE";
        /** 商户中心-商品库存还原 Queen */
        public static final String GOODS_STOCK_REVERT_QUEEN = "GOODS_STOCK_REVERT_QUEEN";
        /** 商户中心-商品库存还原 route key */
        public static final String GOODS_STOCK_REVERT_ROUTE_KEY = "GOODS_STOCK_REVERT_ROUTE_KEY";
        /** 商户中心-商品库存扣减 Queen */
        public static final String GOODS_STOCK_SUB_QUEEN = "GOODS_STOCK_SUB_QUEEN";
        /** 商户中心-商品库存还原 route key */
        public static final String GOODS_STOCK_SUB_ROUTE_KEY = "GOODS_STOCK_SUB_ROUTE_KEY";
    }


    //商户附件 targetType 常量
    public static class DictAttachTargetType {
        /** 商品详情页的附件图片 */
        public static final String ATTACH_PRODUCT_DETAIL = "PRODUCT_DETAIL";
    }
}
