package com.rocogz.syy.operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.dto.PrefectureDto;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 
 * </p>
 *
 * @author yifenrui
 * @since 2020-04-21
 */
@Data
@Accessors(chain = true)
@TableName("operate_column")
public class OperateColumn extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编号
     */
    private String code;

    /**
     * 专区编号
     */
    private String prefectureCode;

    /**
     * 专区名称
     */
    private String prefectureName;

    /**
     * 栏目名称
     */
    private String name;

    /**
     * 栏目说明
     */
    private String columnExplanation;

    /**
     * 栏目方式
     */
    private String columnType;

    /**
     * 栏目方式对应信息code或地址
     */
    private String columnTypeAddress;

    /**
     * 位置值
     */
    private Integer sort;

    /**
     * 图标路径
     */
    private String photoUrl;

    /**
     * 状态
     */
    private String status;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 封装前端分区信息
     */
    @TableField(exist = false)
    private List<PrefectureDto> prefectureList;

    /**
     * 封装前端服务分类信息服务分类名称
     */
    @TableField(exist = false)
    private String serviceName;


}
