package com.rocogz.syy.operation.entity.qr;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;

/**
 * <p>
 * 小程序二维码生成配置
 * </p>
 *
 * @author liangyongtong
 * @since 2020-05-28
 */
@TableName("operate_qr_config")
public class OperateQrConfig extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 生成的二维码类型;如：注册推荐码
     */
    private String qrType;

    /**
     * 说明
     */
    private String introduce;

    /**
     * 接口类型：A/B/C
     */
    private String interfaceType;

    /**
     * 小程序相对路径: 最终路径为 {path}?scene=code
     */
    private String path;

    /**
     * 二维码宽度:默认430
     */
    private Integer width;


    public String getQrType() {
        return qrType;
    }

    public void setQrType(String qrType) {
        this.qrType = qrType;
    }

    public String getIntroduce() {
        return introduce;
    }

    public void setIntroduce(String introduce) {
        this.introduce = introduce;
    }

    public String getInterfaceType() {
        return interfaceType;
    }

    public void setInterfaceType(String interfaceType) {
        this.interfaceType = interfaceType;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    @Override
    public String toString() {
        return "OperateQrConfig{" +
        "qrType=" + qrType +
        ", introduce=" + introduce +
        ", interfaceType=" + interfaceType +
        ", path=" + path +
        ", width=" + width +
        "}";
    }
}
