package com.rocogz.syy.operation.constants;

/**
 * 运营中心基础服务，常量类
 *
 * @author zhangmin
 * @date 2020/4/3
 */
public class OperationConstant {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String TIME_ZONE = "GMT+08:00";

    /**
     * 运营中心基础微服务名称
     */
    public static final String APPLICATION_NAME = "operation-base-service";

    public static class DataStatus {
        /**
         * status 正常状态
         */
        public static final String NORMAL = "NORMAL";
        /**
         * status 锁定状态
         */
        public static final String LOCK = "LOCK";
    }

    //需要审核的业务模块
    public static class ApproveBusinessType {

        //字典类型编号
        public static String TYPE_CODE = "approveBusiness";

        //商品模块
        public static String MERCHANT = "merchant";

        //订单模块
        public static String SALE_ORDER = "saleOrder";

        //订单模块
        public static String GOODS = "goods";

        //订单模块
        public static String ORDER_AFTER = "orderAfter";
    }

    public static final class ColumnType {
        public static final String CATEGORY = "CATEGORY";
        public static final String LABEL = "LABEL";
        public static final String APPLET = "APPLET";
        public static final String H5 = "H5";
        public static final String PC = "PC";
    }

    public static final class ActivityTypeDict {
        public static final String FLASH_SALE = "FLASH_SALE";
    }

    public static final class ActivityRunningStatusDict {
        public static final String NOT_START = "NOT_START";
        public static final String RUNNING = "RUNNING";
        public static final String ENDED = "ENDED";
    }

    public static final class ActivityListStatusDict {
        public static final String DRAFT = "DRAFT";
        public static final String LIST = "LIST";
        public static final String DELIST = "DELIST";
    }

}
