package com.rocogz.syy.operation.entity.activity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 活动关联sku</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021/5/18 10:23 上午</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@TableName("operate_activity_sku")
public class OperateActivitySku extends IdEntity {

    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 商品编号
     */
    private String productCode;

    /**
     * sku编号
     */
    private String skuCode;

    /**
     * 商品原价(积分)
     */
    private String originalCent;

    /**
     * 活动价(积分)
     */
    private BigDecimal activityCent;

    /**
     * 结算价
     */
    private BigDecimal settlementPrice;

    /**
     * 销量
     */
    private Integer salesQuantity;

    /**
     * 排序值
     */
    private String seq;

    /**
     * 活动商品状态
     */
    private String status;

    //传输使用的
    /**
     * 可用库存
     */
    private transient Integer availableStock;

    /**
     * 活动
     */
    private transient OperateActivity  activity;


}
