package com.rocogz.syy.operation.entity.activity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.operation.constants.OperationConstant;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 活动信息</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021/5/18 10:20 上午</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@TableName("operate_activity")
public class OperateActivity extends UserTimeEntity {

    /**
     * 活动编号
     */
    private String code;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 活动类型
     * {@link OperationConstant.ActivityTypeDict}
     */
    private String type;

    /**
     * 活动图片地址
     */
    private String imgUrl;

    /**
     * 活动开始时间
     */
    private LocalDateTime startTime;

    /**
     * 活动结束时间
     */
    private LocalDateTime endTime;

    /**
     * 活动状态
     * {@link OperationConstant.ActivityListStatusDict}
     */
    private String listStatus;

    /**
     * 备注
     */
    private String remark;

    /**
     * 关联的sku
     */
    @TableField(exist = false)
    private List<OperateActivitySku> skus;

    public String getRunningStatus() {
        LocalDateTime now = LocalDateTime.now();
        if (now.compareTo(startTime) < 0 ){
            return OperationConstant.ActivityRunningStatusDict.NOT_START;
        }

        if (now.compareTo(endTime) > 0){
            return OperationConstant.ActivityRunningStatusDict.ENDED;
        }

        return OperationConstant.ActivityRunningStatusDict.RUNNING;
    }
}
