package com.rocogz.syy.operation.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.operation.dto.CategoryLabelRequestDto;
import com.rocogz.syy.operation.dto.TreeDto;
import com.rocogz.syy.operation.entity.Approvement;
import com.rocogz.syy.operation.entity.OperateBanner;
import com.rocogz.syy.operation.entity.OperateBannerPrefecture;
import com.rocogz.syy.operation.entity.OperateColumn;
import com.rocogz.syy.operation.entity.category.OperateCategory;
import com.rocogz.syy.operation.entity.category.OperateCategoryLabel;
import com.rocogz.syy.operation.entity.*;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhangmin
 * @date 2020/4/3
 */
public interface IOperationClientService {

    // =====  start 审核管理->审核申请   ========

    /**
     * 后台列表查询
     *
     * @param approveCode   审批单号
     * @param bussinessCode 业务对象编号
     * @param bussinessName 业务对象名称
     * @param bussinessType 业务类型编号
     * @param bussinessItem 业务项目
     * @param approved      是否已审核,默认未审核
     */
    @GetMapping("/api/operation/approvement")
    PageTable<Approvement> searchApproment(@RequestParam(name = "approveCode", required = false) String approveCode,
                                           @RequestParam(name = "bussinessCode", required = false) String bussinessCode,
                                           @RequestParam(name = "bussinessName", required = false) String bussinessName,
                                           @RequestParam(name = "bussinessType", required = false) String bussinessType,
                                           @RequestParam(name = "bussinessItem", required = false) String bussinessItem,
                                           @RequestParam(name = "approved", defaultValue = "false") Boolean approved,
                                           @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                           @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 判断申请是否重复
     *
     * @param bussinessCode
     * @return
     */
    @GetMapping("/api/operation/approvement/findApprovement")
    Response<Approvement> findApprovement(@RequestParam(name = "bussinessCode", required = false) String bussinessCode);

    /**
     * 创建审批申请
     */
    @PostMapping("/api/operation/approvement/create")
    Response<String> createApprovement(@RequestBody Approvement approve);

    /**
     * 更新审批信息
     */
    @PostMapping("/api/operation/approvement/update")
    Response<String> updateApprovement(@RequestBody Approvement approve);

    /**
     * 审批操作
     */
    @PostMapping("/api/operation/approvement/approve")
    Response<String> approveApprovement(@RequestBody Approvement approve);

    @GetMapping("/api/operation/approvement/getBatchApprove")
    PageTable<Approvement> getBatchApprove(@RequestParam(name = "approveCodes", required = false) String[] approveCodes,
                                           @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                           @RequestParam(name = "page", defaultValue = "1") Integer page);

    //  =========  end of  审核管理->审核申请   ===========

    //  =========  start of  banner 模块   ===========

    /**
     * banner列表
     *
     * @param prefecturekeyword 分区搜索
     * @param status            状态
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/operation/banner")
    PageTable<OperateBanner> findOperateBanner(
            @RequestParam(name = "prefecturekeyword", required = false) String[] prefecturekeyword,
            @RequestParam(name = "status", required = false) String status,
            @RequestParam(name = "showLocation", required = false) String showLocation,
            @RequestParam(name = "linkType", required = false) String linkType,
            @RequestParam(value = "prefectureList", required = false) List<String> prefectureList,
            @RequestParam(name = "limit", defaultValue = "20") int limit,
            @RequestParam(name = "page", defaultValue = "1") int page);

    /**
     * 新增和更新
     *
     * @param operateBanner
     * @return
     */
    @PostMapping("/api/operation/banner/createOrUpdateBanner")
    Response createOrUpdateBanner(@RequestBody OperateBanner operateBanner);

    /**
     * 根据code删除banner
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/banner/deleteBanner")
    Response deleteBanner(@RequestParam(name = "code") String code);

    /**
     * banner状态改变
     *
     * @param operateBanner banner
     * @return
     */
    @PostMapping("/api/operation/banner/status")
    Response switchBannerStatus(@RequestBody OperateBanner operateBanner);

    /**
     * 根据id查询banner信息
     *
     * @param id bannerid
     * @return
     */
    @GetMapping("/api/operation/banner/{id}")
    Response<OperateBanner> getOperateBannerById(@PathVariable("id") Integer id);

    /**
     * banner专区
     *
     * @param code bannerCode
     * @return
     */
    @PostMapping("/api/operation/banner/findPrefectureByCode")
    Response<List<OperateBannerPrefecture>> findPrefectureListByCode(@RequestParam(name = "code") String code);

    /**
     * banner管理-检测title是否重复
     *
     * @param code
     * @param title
     * @return
     */
    @PostMapping("/api/operation/banner/checkTitle")
    Response<List<OperateBanner>> checkTitle(@RequestParam(name = "code", required = false) String code, @RequestParam(name = "title") String title);

    /**
     * 车主端-首页banner信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/banner/findIndexBanner")
    Response<List<OperateBanner>> findIndexBanner(@RequestParam(name = "code") String code);

    /**
     * 车主端-去加油banner信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/banner/findOilingBanner")
    Response<List<OperateBanner>> findOilingBanner(@RequestParam(name = "code") String code, @RequestParam(name = "showLocation") String showLocation);
    // =========  end of  banner 模块   ===========



    //  =========  start of  栏目 模块   ===========

    @GetMapping("/api/operation/column")
    PageTable<OperateColumn> searchColumn(@RequestParam(name = "areaCodes", required = false) String[] areaCodes,
                                          @RequestParam(name = "name", required = false) String name,
                                          @RequestParam(name = "columnType", required = false) String columnType,
                                          @RequestParam(name = "status", required = false) String status,
                                          @RequestParam(value = "prefectureList", required = false) List<String> prefectureList,
                                          @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                          @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 栏目管理-更新栏目的状态和排序
     *
     * @param operateColumn
     * @return
     */
    @PostMapping("/api/operation/column/statusOrSort")
    Response switchColumnStatusOrSort(@RequestBody OperateColumn operateColumn);

    /**
     * 栏目管理-根据code删除栏目
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/column/deleteColumn")
    Response deleteColumn(@RequestParam(name = "code") String code);

    /**
     * 新增和更新operateBlock
     *
     * @param operateColumn
     * @return
     */
    @PostMapping("/api/operation/column/createOrUpdateColumn")
    Response createOrUpdateColumn(@RequestBody OperateColumn operateColumn);

    /**
     * 版块管理-根据id查询栏目
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/column/{id}")
    Response<OperateColumn> getOperateColumnById(@PathVariable("id") Integer id);

    /**
     * 车主端-根据专区code查询栏目
     *
     * @param prefectureCode
     * @return
     */
    @GetMapping("/api/operation/column/findIndexOperateColumn")
    Response<List<OperateColumn>> findIndexOperateColumn(@RequestParam(name = "prefectureCode") String prefectureCode);
    // =========  end of  栏目 模块   ===========


    //  =========  start of  分类页 模块   ===========

    /**
     * 构建分类页的树形结构
     *
     * @return
     */
    @GetMapping("/api/operate/category/getTree")
    Response<List<TreeDto<OperateCategory>>> getTree();

    /**
     * 创建或者编辑分类
     *
     * @param category 分类信息
     */
    @PostMapping("/api/operate/category/saveOrUpdateCategory")
    Response saveOrUpdateCategory(@RequestBody OperateCategory category);

    /**
     * 根据id查询分类信息（包含父分类）
     *
     * @param id id
     * @return
     */
    @GetMapping("/api/operate/category/{id}/get")
    Response<OperateCategory> getCategoryById(@PathVariable("id") Integer id);

    /**
     * 查询分类标签关联的列表
     *
     * @param categoryCode 分类编码
     * @param limit        页大小
     * @param page         页偏移量
     * @return
     */
    @GetMapping("/api/operate/category/searchCategoryLabel")
    PageTable<OperateCategoryLabel> searchCategoryLabel(@RequestParam(name = "categoryCode") String categoryCode,
                                                        @RequestParam(name = "limit", defaultValue = "20") int limit,
                                                        @RequestParam(name = "page", defaultValue = "1") int page);
    /**
     * 根据分类标签关联的id删除对应的记录
     *
     * @param categoryLabelId 分类标签关联的id
     * @return
     */
    @GetMapping("/api/operate/category/deleteCategoryLabelById")
    Response deleteCategoryLabelById(@RequestParam(name = "categoryLabelId") Integer categoryLabelId);

    /**
     * 修改分类标签关联的排序值
     *
     * @param categoryLabel 分类标签关联
     * @return
     */
    @PostMapping("/api/operate/category/changeCategoryLabelSort")
    Response changeCategoryLabelSort(@RequestBody OperateCategoryLabel categoryLabel);

    /**
     * 保存分类和标签的关联关系
     *
     * @param param 请求参数
     * @return
     */
    @PostMapping("/api/operate/category/saveCategoryLabels")
    Response saveCategoryLabels(@RequestBody CategoryLabelRequestDto param);
    // =========  end of  分类页 模块   ===========

    //  =========  start of  推荐商品管理 模块   ===========

    /**
     * 版块管理-列表管理
     * @param name
     * @param status
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/operation/recommendPlate")
    PageTable<OperateRecommendPlate> searchOperateRecommendPlate(@RequestParam(name = "name", required = false) String name,
                                                 @RequestParam(name = "status", required = false) String status,
                                                 @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                                 @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 版块管理-更新版块的状态和排序
     *
     * @param operateRecommendPlate
     * @return
     */
    @PostMapping("/api/operation/recommendPlate/updatePlateSortAndStatus")
    Response updatePlateSortAndStatus(@RequestBody OperateRecommendPlate operateRecommendPlate);

    /**
     * 版块管理-根据code删除版块
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/recommendPlate/deleteOperateRecommendPlate")
    Response deleteOperateRecommendPlate(@RequestParam(name = "code") String code);


    /**
     * 版块管理-新增和更新
     *
     * @param operateRecommendPlate
     * @return
     */
    @PostMapping("/api/operation/recommendPlate/createOrUpdateRecommendPlate")
    Response createOrUpdateRecommendPlate(@RequestBody OperateRecommendPlate operateRecommendPlate);



    /**
     * 检测名称唯一
     * @param id
     * @param name
     * @return
     */
    @GetMapping("/api/operation/recommendPlate/checkOperateRecommendPlateUnique")
    Response<List<OperateRecommendPlate>> checkOperateRecommendPlateUnique(@RequestParam(name = "id",required = false) Integer id,@RequestParam(name = "name") String name);


    /**
     * 版块管理-根据id查询版块
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/recommendPlate/{id}")
    Response<OperateRecommendPlate> getOperateRecommendPlateById(@PathVariable("id") Integer id);


    /**
     * 版块下的商品
     * @param code
     * @return
     */
    @GetMapping("/api/operation/recommendPlate/getRecommendGoodsList")
    Response<List<OperateRecommendPlateGoods>> getRecommendGoodsList(@RequestParam(name = "code") String code);



    /**
     * 版块管理-根据版块code新增更新下面的商品
     *
     * @param code
     * @param merchenctGoodsCode
     * @return
     */
    @GetMapping("/api/operation/recommendPlate/updateBlockMerchenctGoods")
    Response updateBlockMerchenctGoods(@RequestParam(name = "code", required = false) String code,
                                  @RequestParam(name = "merchenctGoodsCode", required = false) String[] merchenctGoodsCode);

    /**
     * 版块管理-根据版块code和商品code删除版块下的商品
     *
     * @param platCode
     * @param merchantGoodsode
     * @return
     */
    @PostMapping("/api/operation/recommendPlate/removeMerchenctGoods")
    Response removeMerchenctGoods(@RequestParam(name = "platCode") String platCode, @RequestParam(name = "merchantGoodsCode") String merchantGoodsode);

    /**
     * 版块管理-商品code更新位置值
     *
     * @param operateRecommendPlateGoods
     * @return
     */
    @PostMapping("/api/operation/recommendPlate/merchenctGoodsSort")
    Response merchenctGoodsSort(@RequestBody OperateRecommendPlateGoods operateRecommendPlateGoods);
    // =========  end of  推荐商品管理 模块   ===========

}
