package com.rocogz.syy.operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 推荐商品版块
 * </p>
 *
 * @author yifenrui
 * @since 2020-10-27
 */
@Data
@Accessors(chain = true)
@TableName("operate_recommend_plate")
public class OperateRecommendPlate extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 编号
     */
    private String code;

    /**
     * 板块名称
     */
    private String name;

    /**
     * 板块说明
     */
    private String description;

    /**
     * 商品数量
     */
    private Integer productNum;

    /**
     * 背景图片
     */
    private String bgImgUrl;

    /**
     * 小logo图片
     */
    private String logoImgUrl;

    /**
     * 排序值
     */
    private Integer sort;

    /**
     * 状态
     */
    private String status;

    /**
     * 创建人账号
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人账号
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 关联的商品信息
     */
    @TableField(exist = false)
    private List<OperateRecommendPlateGoods> goods;
}
