package com.rocogz.syy.operation.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * banner管理-banner表
 * </p>
 *
 * @author yifenrui
 * @since 2020-04-08
 */
@Data
@Accessors(chain = true)
@TableName("operate_banner")
public class OperateBanner extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * banner编码
     */
    private String code;

    /**
     * 标题
     */
    private String title;

    /**
     * 广告语
     */
    private String slogans;

    /**
     * 缩略图路径
     */
    private String photoPath;

    /**
     * 链接类型
     */
    private String linkType;

    /**
     * 链接url
     */
    private String linkUrl;

    /**
     * appid
     */
    private String appid;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 状态
     */
    private String status;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人账号
     */
    private String updateUser;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    /**
     * 创建人账号
     */
    private String createUser;

    /**
     * 展示位置
     */
    private String showLocation;

    /**
     * 封装查询分区结果
     */
    @TableField(exist = false)
    private String prefectureStr;

    /**
     * 封装前端服务分类信息服务分类名称
     */
    @TableField(exist = false)
    private String serviceName;


}
