package com.rocogz.syy.operation.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.operation.dto.CategoryLabelRequestDto;
import com.rocogz.syy.operation.dto.TreeDto;
import com.rocogz.syy.operation.dto.activity.*;
import com.rocogz.syy.operation.entity.*;
import com.rocogz.syy.operation.entity.activity.OperateActivity;
import com.rocogz.syy.operation.entity.activity.OperateActivityLog;
import com.rocogz.syy.operation.entity.activity.OperateActivitySku;
import com.rocogz.syy.operation.entity.category.OperateCategory;
import com.rocogz.syy.operation.entity.category.OperateCategoryLabel;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhangmin
 * @date 2020/4/3
 */
public interface IOperationClientService {

    // =====  start 审核管理->审核申请   ========

    /**
     * 后台列表查询
     *
     * @param approveCode   审批单号
     * @param bussinessCode 业务对象编号
     * @param bussinessName 业务对象名称
     * @param bussinessType 业务类型编号
     * @param bussinessItem 业务项目
     * @param approved      是否已审核,默认未审核
     */
    @GetMapping("/api/operation/approvement")
    PageTable<Approvement> searchApproment(@RequestParam(name = "approveCode", required = false) String approveCode,
                                           @RequestParam(name = "bussinessCode", required = false) String bussinessCode,
                                           @RequestParam(name = "bussinessName", required = false) String bussinessName,
                                           @RequestParam(name = "bussinessType", required = false) String bussinessType,
                                           @RequestParam(name = "bussinessItem", required = false) String bussinessItem,
                                           @RequestParam(name = "approved", defaultValue = "false") Boolean approved,
                                           @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                           @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 判断申请是否重复
     *
     * @param bussinessCode
     * @return
     */
    @GetMapping("/api/operation/approvement/findApprovement")
    Response<Approvement> findApprovement(@RequestParam(name = "bussinessCode", required = false) String bussinessCode);

    /**
     * 创建审批申请
     */
    @PostMapping("/api/operation/approvement/create")
    Response<String> createApprovement(@RequestBody Approvement approve);

    /**
     * 更新审批信息
     */
    @PostMapping("/api/operation/approvement/update")
    Response<String> updateApprovement(@RequestBody Approvement approve);

    /**
     * 审批操作
     */
    @PostMapping("/api/operation/approvement/approve")
    Response<String> approveApprovement(@RequestBody Approvement approve);

    @GetMapping("/api/operation/approvement/getBatchApprove")
    PageTable<Approvement> getBatchApprove(@RequestParam(name = "approveCodes", required = false) String[] approveCodes,
                                           @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                           @RequestParam(name = "page", defaultValue = "1") Integer page);

    //  =========  end of  审核管理->审核申请   ===========

    //  =========  start of  banner 模块   ===========

    /**
     * banner列表
     *
     * @return
     */
    @GetMapping("/api/operation/banner")
    PageTable<OperateBanner> findOperateBanner(
            @RequestParam(name = "title", required = false) String title,
            @RequestParam(name = "status", required = false) String status,
            @RequestParam(name = "showLocation", required = false) String showLocation,
            @RequestParam(name = "linkType", required = false) String linkType,
            @RequestParam(name = "limit", defaultValue = "20") int limit,
            @RequestParam(name = "page", defaultValue = "1") int page);

    /**
     * 新增和更新
     *
     * @param operateBanner
     * @return
     */
    @PostMapping("/api/operation/banner/createOrUpdateBanner")
    Response createOrUpdateBanner(@RequestBody OperateBanner operateBanner);

    /**
     * 根据code删除banner
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/banner/deleteBanner")
    Response deleteBanner(@RequestParam(name = "code") String code);

    /**
     * banner状态改变
     *
     * @param operateBanner banner
     * @return
     */
    @PostMapping("/api/operation/banner/status")
    Response switchBannerStatus(@RequestBody OperateBanner operateBanner);

    /**
     * 根据id查询banner信息
     *
     * @param id bannerid
     * @return
     */
    @GetMapping("/api/operation/banner/{id}")
    Response<OperateBanner> getOperateBannerById(@PathVariable("id") Integer id);

    /**
     * 根据标题和链接类型查询banner信息
     *
     * @param title    标题
     * @param linkType 链接类型
     * @return
     */
    @GetMapping("/api/operation/banner/getBannerByTitleAndLinkType")
    Response<OperateBanner> getBannerByTitleAndLinkType(@RequestParam(name = "title") String title,
                                                        @RequestParam(name = "linkType") String linkType);

    /**
     * banner管理-检测title是否重复
     *
     * @param code
     * @param title
     * @return
     */
    @PostMapping("/api/operation/banner/checkTitle")
    Response<List<OperateBanner>> checkTitle(@RequestParam(name = "code", required = false) String code, @RequestParam(name = "title") String title);

    /**
     * 查询所有banner
     *
     * @param status 状态（非必填）
     * @return
     */
    @GetMapping("/api/operation/banner/findAllBanners")
    Response<List<OperateBanner>> findAllBanners(@RequestParam(name = "status", required = false) String status);
    // =========  end of  banner 模块   ===========


    //  =========  start of  栏目 模块   ===========

    @GetMapping("/api/operation/column")
    PageTable<OperateColumn> searchColumn(@RequestParam(name = "areaCodes", required = false) String[] areaCodes,
                                          @RequestParam(name = "name", required = false) String name,
                                          @RequestParam(name = "columnType", required = false) String columnType,
                                          @RequestParam(name = "status", required = false) String status,
                                          @RequestParam(value = "prefectureList", required = false) List<String> prefectureList,
                                          @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                          @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 栏目管理-更新栏目的状态和排序
     *
     * @param operateColumn
     * @return
     */
    @PostMapping("/api/operation/column/statusOrSort")
    Response switchColumnStatusOrSort(@RequestBody OperateColumn operateColumn);

    /**
     * 栏目管理-根据code删除栏目
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/column/deleteColumn")
    Response deleteColumn(@RequestParam(name = "code") String code);

    /**
     * 新增和更新operateBlock
     *
     * @param operateColumn
     * @return
     */
    @PostMapping("/api/operation/column/createOrUpdateColumn")
    Response createOrUpdateColumn(@RequestBody OperateColumn operateColumn);

    /**
     * 版块管理-根据id查询栏目
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/column/{id}")
    Response<OperateColumn> getOperateColumnById(@PathVariable("id") Integer id);

    /**
     * 查询所有栏目，查询条件非必填
     *
     * @param status 状态
     * @return
     */
    @GetMapping("/api/operation/column/findAllColumns")
    Response<List<OperateColumn>> findAllColumns(@RequestParam(name = "status", required = false) String status);
    // =========  end of  栏目 模块   ===========


    //  =========  start of  分类页 模块   ===========

    /**
     * 分页查询分类页
     *
     * @param name  名称
     * @param code  编码
     * @param level 等级
     * @param limit 分页
     * @param page  分页
     * @return
     */
    @GetMapping("/api/operate/category")
    PageTable<OperateCategory> searchCategory(@RequestParam(name = "name", required = false) String name,
                                              @RequestParam(name = "code", required = false) String code,
                                              @RequestParam(name = "level", required = false) Integer level,
                                              @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                              @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 构建分类页的树形结构
     *
     * @return
     */
    @GetMapping("/api/operate/category/getTree")
    Response<List<TreeDto<OperateCategory>>> getTree();

    /**
     * 创建或者编辑分类
     *
     * @param category 分类信息
     */
    @PostMapping("/api/operate/category/saveOrUpdateCategory")
    Response saveOrUpdateCategory(@RequestBody OperateCategory category);

    /**
     * 根据id查询分类信息（包含父分类）
     *
     * @param id id
     * @return
     */
    @GetMapping("/api/operate/category/{id}/get")
    Response<OperateCategory> getCategoryById(@PathVariable("id") Integer id);

    /**
     * 查询分类标签关联的列表
     *
     * @param categoryCode 分类编码
     * @param limit        页大小
     * @param page         页偏移量
     * @return
     */
    @GetMapping("/api/operate/category/searchCategoryLabel")
    PageTable<OperateCategoryLabel> searchCategoryLabel(@RequestParam(name = "categoryCode") String categoryCode,
                                                        @RequestParam(name = "limit", defaultValue = "20") int limit,
                                                        @RequestParam(name = "page", defaultValue = "1") int page);

    /**
     * 根据分类标签关联的id删除对应的记录
     *
     * @param categoryLabelId 分类标签关联的id
     * @return
     */
    @GetMapping("/api/operate/category/deleteCategoryLabelById")
    Response deleteCategoryLabelById(@RequestParam(name = "categoryLabelId") Integer categoryLabelId);

    /**
     * 修改分类标签关联的排序值
     *
     * @param categoryLabel 分类标签关联
     * @return
     */
    @PostMapping("/api/operate/category/changeCategoryLabelSort")
    Response changeCategoryLabelSort(@RequestBody OperateCategoryLabel categoryLabel);

    /**
     * 保存分类和标签的关联关系
     *
     * @param param 请求参数
     * @return
     */
    @PostMapping("/api/operate/category/saveCategoryLabels")
    Response saveCategoryLabels(@RequestBody CategoryLabelRequestDto param);

    /**
     * 查询所有分类，查询条件都为非必填
     *
     * @param level      等级
     * @param parentCode 父节点
     * @param status     状态
     * @param loadLabel  是否加载关联的标签
     * @return
     */
    @GetMapping("/api/operate/category/findAllCategory")
    Response<List<OperateCategory>> findAllCategory(@RequestParam(name = "level", required = false) Integer level,
                                                    @RequestParam(name = "paraentCode", required = false) String parentCode,
                                                    @RequestParam(name = "status", required = false) String status,
                                                    @RequestParam(name = "loadLabel", defaultValue = "false") Boolean loadLabel);
    // =========  end of  分类页 模块   ===========

    //  =========  start of  推荐商品管理 模块   ===========

    /**
     * 版块管理-列表管理
     *
     * @param name
     * @param status
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/operation/recommendPlate")
    PageTable<OperateRecommendPlate> searchOperateRecommendPlate(@RequestParam(name = "name", required = false) String name,
                                                                 @RequestParam(name = "status", required = false) String status,
                                                                 @RequestParam(name = "limit", defaultValue = "20") Integer limit,
                                                                 @RequestParam(name = "page", defaultValue = "1") Integer page);

    /**
     * 版块管理-更新版块的状态和排序
     *
     * @param operateRecommendPlate
     * @return
     */
    @PostMapping("/api/operation/recommendPlate/updatePlateSortAndStatus")
    Response updatePlateSortAndStatus(@RequestBody OperateRecommendPlate operateRecommendPlate);

    /**
     * 版块管理-根据code删除版块
     *
     * @param code
     * @return
     */
    @PostMapping("/api/operation/recommendPlate/deleteOperateRecommendPlate")
    Response deleteOperateRecommendPlate(@RequestParam(name = "code") String code);


    /**
     * 版块管理-新增和更新
     *
     * @param operateRecommendPlate
     * @return
     */
    @PostMapping("/api/operation/recommendPlate/createOrUpdateRecommendPlate")
    Response createOrUpdateRecommendPlate(@RequestBody OperateRecommendPlate operateRecommendPlate);


    /**
     * 检测名称唯一
     *
     * @param id
     * @param name
     * @return
     */
    @GetMapping("/api/operation/recommendPlate/checkOperateRecommendPlateUnique")
    Response<List<OperateRecommendPlate>> checkOperateRecommendPlateUnique(@RequestParam(name = "id", required = false) Integer id, @RequestParam(name = "name") String name);


    /**
     * 版块管理-根据id查询版块
     *
     * @param id
     * @return
     */
    @GetMapping("/api/operation/recommendPlate/{id}")
    Response<OperateRecommendPlate> getOperateRecommendPlateById(@PathVariable("id") Integer id);


    /**
     * 版块下的商品
     *
     * @param code
     * @return
     */
    @GetMapping("/api/operation/recommendPlate/getRecommendGoodsList")
    Response<List<OperateRecommendPlateGoods>> getRecommendGoodsList(@RequestParam(name = "code") String code);


    /**
     * 版块管理-根据版块code新增更新下面的商品
     *
     * @param code
     * @param merchenctGoodsCode
     * @return
     */
    @GetMapping("/api/operation/recommendPlate/updateBlockMerchenctGoods")
    Response updateBlockMerchenctGoods(@RequestParam(name = "code", required = false) String code,
                                       @RequestParam(name = "merchenctGoodsCode", required = false) String[] merchenctGoodsCode);

    /**
     * 版块管理-根据版块code和商品code删除版块下的商品
     *
     * @param platCode
     * @param merchantGoodsode
     * @return
     */
    @PostMapping("/api/operation/recommendPlate/removeMerchenctGoods")
    Response removeMerchenctGoods(@RequestParam(name = "platCode") String platCode, @RequestParam(name = "merchantGoodsCode") String merchantGoodsode);

    /**
     * 版块管理-商品code更新位置值
     *
     * @param operateRecommendPlateGoods
     * @return
     */
    @PostMapping("/api/operation/recommendPlate/merchenctGoodsSort")
    Response merchenctGoodsSort(@RequestBody OperateRecommendPlateGoods operateRecommendPlateGoods);

    /**
     * 查询所有版块信息，查询参数非必填
     *
     * @param status    状态
     * @param loadGoods 是否加载商品信息
     * @return
     */
    @GetMapping("/api/operation/recommendPlate/findAllPlates")
    Response<List<OperateRecommendPlate>> findAllPlates(@RequestParam(name = "status", required = false) String status,
                                                        @RequestParam(name = "loadGoods", defaultValue = "false") Boolean loadGoods);
    // =========  end of  推荐商品管理 模块   ===========

    // =========  start of  活动管理 模块   ===========

    /**
     * 管理后台分页查询活动数据
     *
     * @param param 查询参数
     * @return
     */
    @PostMapping("/api/operation/activity/search")
    PageTable<OperateActivity> searchActivity(@RequestBody AdminSearchActivityParamDto param);

    /**
     * 新增或者编辑活动
     *
     * @param activity 活动信息
     * @return
     */
    @PostMapping("/api/operation/activity/createOrEditActivity")
    Response createOrEditActivity(@RequestBody OperateActivity activity);

    /**
     * 根据活动编码查询活动信息
     *
     * @param code 活动编码
     * @return
     */
    @GetMapping("/api/operation/activity/getActivityByCode")
    Response<OperateActivity> getActivityByCode(@RequestParam(name = "code") String code);

    /**
     * 根据活动编码删除活动
     *
     * @param code 活动编码
     * @return
     */
    @PostMapping("/api/operation/activity/deleteActivityByCode")
    Response deleteActivityByCode(@RequestParam(name = "code") String code);

    /**
     * 切换活动状态
     *
     * @param param 参数
     * @return
     */
    @PostMapping("/api/operation/activity/switchActivityStatus")
    Response switchActivityStatus(@RequestBody SwitchListStatusParamDto param);

    /**
     * 分页查询活动商品
     *
     * @param param 参数
     * @return
     */
    @GetMapping("/api/operation/activitySku/search")
    PageTable<OperateActivitySku> searchActivitySku(@SpringQueryMap ActivitySkuSearchParamDto param);

    /**
     * 根据活动编码查询活动商品信息
     *
     * @param activityCode 活动编码
     * @return
     */
    @GetMapping("/api/operation/activitySku/findActivitySkuByActivityCode")
    Response<List<OperateActivitySku>> findActivitySkuByActivityCode(@RequestParam(name = "activityCode") String activityCode);

    /**
     * 查询活动SKUCode
     * @param query
     * @return
     */
    @PostMapping("/api/operation/activitySku/getByQueryDto")
     Response<OperateActivitySku> getActivitySkuByQueryDto(@RequestBody ActivitySkuQueryDto query);

    /**
     * 增加活动销量,是由商户中心库存出库后发送消息，由消息中心消费 调用到这里
     * @param dto
     */
    @PostMapping("/api/operation/activitySku/increaseActivitySales")
    Response increaseActivitySales(@RequestBody ActivitySkuSalesCommandDto dto);


    /**
     * 减少活动销量，是由商户中心库存出库还原后发送消息，由消息中心消费 调用到这里
     * @param dto
     */
    @PostMapping("/api/operation/activitySku/reduceActivitySales")
    Response reduceActivitySales(@RequestBody ActivitySkuSalesCommandDto dto);

    /**
     * 查询活动操作日志
     *
     * @param activityCode 活动偏好
     * @param limit        页大小
     * @param page         偏移量
     * @return
     */
    @GetMapping("/api/operation/activity/log/search")
    PageTable<OperateActivityLog> searchActivityLog(@RequestParam(name = "activityCode") String activityCode,
                                                    @RequestParam(name = "limit", defaultValue = "20") int limit,
                                                    @RequestParam(name = "page", defaultValue = "1") int page);

    // =========  start of  活动管理 模块   ===========

}
