package com.rocogz.syy.operation.constants;

/**
 * 运营中心基础服务，常量类
 *
 * @author zhangmin
 * @date 2020/4/3
 */
public class OperationConstant {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String TIME_ZONE = "GMT+08:00";

    /**
     * 运营中心基础微服务名称
     */
    public static final String APPLICATION_NAME = "operation-base-service";

    /**
     * 活动序号
     */
    public final static String ACTIVITY_CODE = "ACTIVITY_CODE";

    public static class DictData {
        /**
         * 注册推荐码类型
         */
        public static final String REGISTER_IIUV_TYPE = "REGISTER_IIUV_TYPE";
        /**
         * 推荐码商户类型
         */
        public static final String REGISTER_IIUV_TYPE_MD = "MD";
        /**
         * 推荐码个人类型
         */
        public static final String REGISTER_IIUV_TYPE_SP = "SP";

        /**
         * 通用的是
         */
        public static final String COMMON_YES = "Y";
        /**
         * 通用的否
         */
        public static final String COMMON_NO = "N";

        /**
         * 注册推荐码 小程序配置信息
         */
        public static final String IIUV = "IIUV";
    }

    public static class DataStatus {
        /**
         * status 正常状态
         */
        public static final String NORMAL = "NORMAL";
        /**
         * status 锁定状态
         */
        public static final String LOCK = "LOCK";
    }

    //审核的业务回调状态
    public static class ApproveCallBackStatus {

        //成功
        public static String CALLBACK_SUCCESS = "SUCCESS";

        //失败
        public static String CALLBACK_FAIL = "FAIL";
    }

    //需要审核的业务模块
    public static class ApproveBusinessType {

        //字典类型编号
        public static String TYPE_CODE = "approveBusiness";

        //商品模块
        public static String MERCHANT = "merchant";

        //订单模块
        public static String SALE_ORDER = "saleOrder";

        //订单模块
        public static String GOODS = "goods";

        //订单模块
        public static String ORDER_AFTER = "orderAfter";
    }

    //审批->商品模块->需要审核的项目
    public static class ApproveMerchantItems {
        //字典类型
        public static String MODULE_CODE = ApproveBusinessType.MERCHANT;

        //商户模块下的 门店上架 审核项目编号
        public static String STORE_LIST = "STORE_LIST";
        public static String STORE_DELIST = "STORE_DELIST";

        // 商户模块下的 商品上架  审核项目编号
        public static String GOODS_LIST = "GOODS_LIST";
    }

    //审批->销售订单模块->需要审核的项目
    public static class ApproveSaleOrderItems {
        //字典类型
        public static String MODULE_CODE = ApproveBusinessType.SALE_ORDER;
        // 提现订单审核
        public static String WITHDRAWALS_APPROVE = "WITHDRAWALS_APPROVE";

        //下面是订单模块的 审核项目编号

    }

    //审批->售后订单模块->需要审核的项目
    public static class ApproveOrderAfterItems {
        //字典类型
        public static String MODULE_CODE = ApproveBusinessType.ORDER_AFTER;

        // 仅退款
        public static String REFUND_LIST = "REFUND_LIST";

        // 退货
        public static String RETURN_REFUND_LIST = "RETURN_REFUND_LIST";

        // 换货
        public static String EXCHANGE_LIST = "EXCHANGE_LIST";


        //取消订单申请
        public static String CANCEL_ORDER_APPLY = "CANCEL_ORDER_APPLY";
    }


    //栏目服务
    public static class ColumnService {

        //服务分类
        public static String SERVICE_TYPE = "SERVICE";
    }


    /**
     * 二维码关联的 推荐码/跳转路径 标示类型
     */
    public static class DictOperateQrRelationType {

        /**
         * 推荐码标示
         */
        public final static String TYPE_IIUV = "IIUV";

        /**
         * 跳转路径标示
         */
        public final static String TYPE_JUMP = "JUMP";


    }

    public static final class ColumnType {
        public static final String CATEGORY = "CATEGORY";
        public static final String LABEL = "LABEL";
        public static final String APPLET = "APPLET";
        public static final String H5 = "H5";
        public static final String PC = "PC";
    }

    public static final class ActivityTypeDict {
        public static final String FLASH_SALE = "FLASH_SALE";
    }

    public static final class ActivityRunningStatusDict {
        public static final String NOT_START = "NOT_START";
        public static final String RUNNING = "RUNNING";
        public static final String ENDED = "ENDED";
    }

    public static final class ActivityListStatusDict {
        public static final String DRAFT = "DRAFT";
        public static final String LIST = "LIST";
        public static final String DELIST = "DELIST";
    }

    public static final class ActivitySkuStatusDict {
        public static final String LIST = "LIST";
        public static final String DELIST = "DELIST";
    }

    public static final class ActivityOperateDict {
        public static final String CREATE = "活动新增";
        public static final String EDIT = "活动修改";
        public static final String LIST = "活动上架";
        public static final String DELIST = "活动下架";

    }
}