package com.rocogz.syy.operation.entity.activity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.constants.OperationConstant;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * <dl>
 * <dd>Description: 活动关联sku</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021/5/18 10:23 上午</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@TableName("operate_activity_sku")
public class OperateActivitySku extends IdEntity {

    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 商品编号
     */
    private String productCode;

    /**
     * sku编号
     */
    private String skuCode;

    /**
     * 活动价(积分)
     */
    private BigDecimal activityCent;

    /**
     * 结算价
     */
    private BigDecimal settlementPrice;

    /**
     * 销量
     */
    private Integer salesQuantity;

    /**
     * 排序值
     */
    private String seq;

    /**
     * 活动商品状态
     * {@link OperationConstant.ActivitySkuStatusDict}
     */
    private String status;

    //传输使用的
    /**
     * 可用库存
     */
    private transient Integer availableStock;

    /**
     * 活动
     */
    private transient OperateActivity  activity;

    /**
     * 可以下单
     * @return
     */
    public Boolean canOrder(){

        if(Objects.isNull(this.activity)) {
            return false;
        }

        if(!this.getActivity().getRunningStatus().equals(OperationConstant.ActivityRunningStatusDict.RUNNING)) {
            return  false;
        }

        if(!this.getActivity().getListStatus().equals(OperationConstant.ActivityListStatusDict.LIST)){
            return false;
        }

        if(!this.status.equals(OperationConstant.ActivitySkuStatusDict.LIST)){
            return false;
        }

        return true;

    }


}
