package com.rocogz.syy.order.dto;

import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.constant.OrderSegmentEnum;
import lombok.Data;

/**
 * 后台管理订单 搜索
 * @author zhangmin
 * @date 2020/6/15
 */
@Data
public abstract class AdminBaseSearchDto {

    public static final String SPLITER = ",";

    private Boolean export = Boolean.FALSE;

    /**
     * 订单编号,在主订单号或子订单号列上搜索
     */
    private String orderCode;

    /**
     * 子订单号,在子订单号列上搜索
     */
    private String orderItemCode;

    /**
     * 订单类型
     */
    private String orderType;

    //订单分区
    private OrderSegmentEnum segment;

    /**
     * 销售渠道
     * @see OrderConstant.UserVisitChannel
     */
    private String channel;

    /**
     * 订单来源平台码
     */
    private String platformCode;

    /**
     * 会员编号
     */
    private String userCode;

    /**
     * 会员openid
     */
    private String userOpenid;

    /**
     * 会员手机号
     */
    private String userMobile;


    /**
     * 订单状态
     */
    private String status;

    /**
     * 下单时间
     */
    private String createStartTime;

    private String createEndTime;

    private Integer limit = 20;

    private Integer page = 1;


    //导出的订单必须 < maxOrderId
    private Integer maxOrderId;

}
