package com.rocogz.syy.order.entity.invoice;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/11/30 下午7:01</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class OrderInvoice extends UserTimeEntity {

    /**
     * 开票会员的union id
     */
    private String unionId;

    /**
     * 发票申请单号
     */
    private String applyCode;

    /**
     * 发票类型
     * {@link com.rocogz.syy.order.constant.OrderConstant.OrderInvoiceType}
     */
    private String invoiceType;

    /**
     * 申请日期
     */
    private LocalDateTime applyTime;

    /**
     * 开票时间
     */
    private LocalDateTime invoicedTime;

    /**
     * 抬头类型
     * {@link com.rocogz.syy.order.constant.OrderConstant.OrderInvoiceTitleType}
     */
    private String titleType;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 发票税号
     */
    private String invoiceNo;

    /**
     * 开户银行
     */
    private String bankName;

    /**
     * 银行账户
     */
    private String bankAccount;

    /**
     * 企业电话
     */
    private String companyPhone;

    /**
     * 企业地址
     */
    private String companyAddress;

    /**
     * 发票的接收方式
     * {@link com.rocogz.syy.order.constant.OrderConstant.OrderInvoiceReceiveWay}
     */
    private String receiveWay;

    /**
     * 接收发票的手机号R
     */
    private String mobile;

    /**
     * 接收发票的电子邮箱
     */
    private String email;

    /**
     * 开票金额
     */
    private BigDecimal invoiceAmount;

    /**
     * 状态：待处理，开票中，已开票
     * {@link com.rocogz.syy.order.constant.OrderConstant.OrderInvoiceStatus}
     */
    private String status;

    /**
     * 发票关联的订单
     */
    @TableField(exist = false)
    private List<SaleOrder> orders;
}
