package com.rocogz.syy.order.constant;

import com.google.common.collect.Lists;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

import com.rocogz.syy.order.constant.OrderConstant.DictOrderStatus;
/**
 * 商户端 订单核销量统计 选项
 *
 * @author zhangmin
 * @date 2020/5/21
 */
@Getter @Setter
public class OrderStatisOption {

    //门店号
    private String storeCode;

    //统计时间方式
    private StatisTimeRangeEnum statisWay;

    /**
     * 统计的订单状态：空表示不限制订单状态
     */
    private List<String> statusList;

    /**
     * 统计的订单类型：空表示不限制订单类型
     */
    private List<String> orderTypeList;

    //自定义时间统计方式：传入到时间
    private String startTime;

    private String endTime;

    /**
     * 是否是按照预约时间统计,否则按照订单下单时间统计
     */
    private boolean statisByAppointTime;

    public OrderStatisOption() {
    }

    /**
     * 默认统计：不限制订单类型,订单状态是已核销的
     * @param storeCode
     * @param timeRange
     */
    public OrderStatisOption(String storeCode, StatisTimeRangeEnum timeRange) {
        //默认统计的订单状态是已核销的
        this(storeCode,timeRange,null,Lists.newArrayList(DictOrderStatus.EVALUATED, DictOrderStatus.PENDING_EVALUATE));
    }


    public OrderStatisOption(String storeCode, StatisTimeRangeEnum timeRange,List<String> orderTypeList,List<String> statusList) {
        this.storeCode = storeCode;
        this.statisWay = timeRange;
        if(!StatisTimeRangeEnum.CUSTOM.equals(timeRange)) {
            this.startTime = timeRange.getStartTime();
            this.endTime = timeRange.getEndTime();
        }

        this.orderTypeList = orderTypeList;
        this.statusList = statusList;
    }



    /**
     * 自定义时间范围统计
     * @param storeCode
     * @param startTime
     * @param endTime
     */
    public OrderStatisOption(String storeCode, String startTime, String endTime) {
        this.storeCode = storeCode;
        this.statisWay = StatisTimeRangeEnum.CUSTOM;
        this.startTime = startTime;
        this.endTime = endTime;
    }
}
