package com.rocogz.syy.order.entity.goods;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 订单中心-商品订单收货地址
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-08-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_goods_order_delivery_address")
public class GoodsOrderDeliveryAddress extends IdEntity {

    private static final long serialVersionUID = 4421594597414149044L;
    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 收货人手机号
     */
    private String mobile;

    /**
     * 收货人
     */
    private String addressee;

    /**
     * 地址-省份
     */
    private String addressProvince;

    /**
     * 地址-城市
     */
    private String addressCity;

    /**
     * 地址-区/县
     */
    private String addressDistrict;

    /**
     * 地址-街道门牌号等信息
     */
    private String addressStreet;

    /**
     * 完整地址
     */
    private String fullAddress;

    /**
     * 标签名称
     */
    private String labelName;


}
