package com.rocogz.syy.order.constant;

import java.math.BigDecimal;

/**
 * 常量
 *
 * @author：zhangmin
 * @since：2020/4/6
 */
public final class OrderConstant {

    public static final String APPLICATION_NAME = "order-base-service";

    /**
     * 对接平台 roco车服平台码,该平台码 来源于 基础服务系统中：basic_docking_platform表
     */
    public static final String DICT_PLATFORM_CODE_CAR_SERVICE = "SYY";

    /**
     *调用其他平台下单接口时, 最多尝试5次[不包括第一次]
     */
    public static final int MAX_RETRY_TIMES = 5;

    /**
     * 元和分的转换进制, 微信支付时使用的是分为单位.
     */
    public static final BigDecimal YUAN_FEE_EXCHANGE = new BigDecimal(100);

    /**
     * 提现订单审核中心回调地址
     */
    public static final String WITHDRAWALS_APPROVEMENT_CALL_BACK_URL = "/api/order/withdrawals-record/approvementCallBack";

    /** 公共的状态 是 */
    public final static String COMMON_STATUS_YES = "Y";

    /** 公共的状态 启用 */
    public final static String COMMON_STATUS_OPEN = "OPEN";

    /** 公共的状态 停用 */
    public final static String COMMON_STATUS_LOCK = "LOCK";

    // ======= 扫码核销前缀 =====>
    /** 使用服务券核销的的服务订单，扫码核销前缀 */
    public final static String COUPON_ORDER_WRITEOFF_CODE_PREFIX = "S";

    /** 使用积分兑换的的服务订单，扫码核销前缀 */
    public final static String COUPON_POINT_ORDER_WRITEOFF_CODE_PREFIX = "P";

    /** 预约订单,扫码核销前缀 */
    public final static String APPOINT_ORDER_WRITEOFF_CODE_PREFIX = "A";

    /** 车务平台中 订单核销码 前缀 */
    public final static String PICC_ORDER_WRITEOFF_CODE_PREFIX = "OD";

    /** 订单编码发号器编码 */
    public final static String SALE_ORDER_CODE_SERIAL_NO = "SALE_ORDER_CODE";


    /**
     * 订单类型
     */
    public static class DictOrderType {
        //字典类型编号
        public static final String TYPE_CODE = "ORDER_TYPE";

        //=== 下面是字典值

        /**
         * 提现订单
         * 提现订单状态变化流程如下，不是主订单信息的状态：
         * 车主端下单（PENDING）-> 后台管理审核通过(PENDING_PROCESS) -> 后台导出提现订单数据并操作为处理中（PROCESSING） -> 后台确定转账结果(SUCCESS/FAIL)
         */
        public static final String WITHDRAWALS_ORDER = "WITHDRAWALS_ORDER";

        /**
         * 商品订单
         * 商品订单状态变化流程如下
         * 车主端下单（PENDING_DELIVERY）-> 后台管理发货(DELIVERED) -> 车主端用户确认收货（FINISHED）
         */
        public static final String GOODS_ORDER = "GOODS_ORDER";
    }

    /**
     * 下订单渠道
     */
    public static class DictChannel {
        //字典类型编号
        public static final String TYPE_CODE = "CHANNEL";

        //=== 下面是字典值

        //车主端
        public static final String CAR_OWNER_WEAPP = "CAR_OWNER_WEAPP";

        //商户端
        public static final String MERCHANT_WEAPP = "MERCHANT_WEAPP";

        //管理后台
        public static final String ADMIN_DASHBOARD = "ADMIN_DASHBOARD";

        //接口调用
        public static final String API_CALL = "API_CALL";

        //ROCO特惠商城
        public static final String ROCO_MALL = "ROCO_MALL";
    }

    /**
     * 下单状态
     */
    public static class DictOrderStatus {
        //字典类型编号
        public static final String TYPE_CODE = "SALE_ORDER_STATUS";

        //=== 下面是字典值

        //待支付 （加油电子券订单刚创建时状态是待支付, 支付成功后是  "处理中"）
        public static final String PENDING_PAY = "PENDING_PAY";

        //处理中
        public static final String PROCESSING = "PROCESSING";

        //待使用,支付成功后就是待使用
        public static final String PENDING_USE = "PENDING_USE";

        //待发货(有发货步骤的订单，支付完成后就是待发货)
        public static final String PENDING_DELIVERY = "PENDING_DELIVERY";

        //待领取(转赠的商品订单，支付完成之后是待领取)
        public static final String PENDING_RECEIVE = "PENDING_RECEIVE";

        //待填写地址(有发货步骤的赠送订单，领取后是待填写地址)
        public static final String PENDING_SET_ADDRESS = "PENDING_SET_ADDRESS";

        //已发货(有发货步骤的订单，发货之后就是已发货)
        public static final String DELIVERED = "DELIVERED";

        //待评价,使用以后（核销成功后）就是待评价
        public static final String PENDING_EVALUATE = "PENDING_EVALUATE";

        //已评价
        public static final String EVALUATED = "EVALUATED";

        //已完成
        public static final String FINISHED = "FINISHED";

        //已取消
        public static final String CANCELED = "CANCELED";

        //已过期
        public static final String EXPIRED = "EXPIRED";

    }

    /**
     * 订单支付方式================================
     */
    public static class DictPayWay {
        //字典类型编号
        public static final String TYPE_CODE = "PAYMENT_WAY";

        //=== 下面是字典值

        //电子券支付
        public static final String TICKET = "TICKET";

        //积分支付，由于以前叫"加油电子券支付",所以字典值就不改了,该支付方式的label改成积分支付
        public static final String OIL_TICKET = "OIL_TICKET";

        //代金券支付
        public static final String VOUCHER = "VOUCHER";

        //服务券支付
        public static final String COUPON = "COUPON";

        //外系统预约支付
        public static final String EXTERNAL_APPOINT = "EXTERNAL_APPOINT";
        //现金支付之 微信支付
        public static final String WEIXIN = "WEIXIN";
        //现金支付之 支付宝支付
        public static final String ALIPAY = "ALIPAY";
    }

    /**
     * 支付单的 支付状态
     */
    public static class DictPayStatus {
        //字典类型编号
        public static final String TYPE_CODE = "PAYMENT_STATUS";

        //=== 下面是字典值

        //未支付
        public static final String UN_PAY = "UNPAY";

        //部分支付
        public static final String PART_PAY = "PART_PAY";

        //支付完成
        public static final String PAIED = "PAIED";

    }


    /**
     * 订单退款状态
     */
    public static class DictRefundStatus {
        //字典类型编号
        public static final String TYPE_CODE = "ORDER_REFUND_STATUS";

        //=== 下面是字典值
        //退款中
        public static final String REFUNDING = "REFUNDING";

        //已退回
        public static final String REFUNDED = "REFUNDED";
    }

    /**
     * 订单 操作动作,用来记录操作流水
     */
    public static final class DictOrderAction {

        //字典类型编号
        public static final String TYPE_CODE = "ORDER_ACTION";

        //=== 下面是字典值

        //创建订单
        public static final String CREATE = "CREATE";

        //支付订单
        public static final String PAY = "PAY";

        //订单使用券
        public static final String USE_COUPON = "USE_COUPON";

        //核销订单
        public static final String WRITE_OFF = "WRITE_OFF";

        //取消订单
        public static final String CANCEL = "CANCEL";

        //结算
        public static final String SETTLE = "SETTLE";

        //逻辑删除
        public static final String DELETE = "DELETE";


        // === 商品订单 相关操作
        // 商品订单 -> 创建
        public static final String GOODS_ORDER_CREATE = "GOODS_ORDER_CREATE";
        // 商品订单 -> 取消
        public static final String GOODS_ORDER_CANCEL = "GOODS_ORDER_CANCEL";
        // 商品订单 -> 支付
        public static final String GOODS_ORDER_PAY = "GOODS_ORDER_PAY";
        // 商品订单 -> 赠送订单领取
        public static final String GOODS_ORDER_BESTOW_RECEIVE = "GOODS_ORDER_BESTOW_RECEIVE";
        // 商品订单 -> 赠送订单填写地址
        public static final String GOODS_ORDER_SET_ADDRESS = "GOODS_ORDER_SET_ADDRESS";
        // 商品订单 -> 发货
        public static final String GOODS_ORDER_SEND = "GOODS_ORDER_SEND";
        // 商品订单 -> 确认收货
        public static final String GOODS_ORDER_CONFIRM = "GOODS_ORDER_CONFIRM";

    }





    /**
     * 订单 结算状态
     */
    public static class DictSettleStatus {

        //字典类型编号
        public static final String TYPE_CODE = "SETTLEMENT_STATUS";

        //=== 下面是字典值

        // 未结算
        public static final String UN_SETTLE = "UN_SETTLE";

        //已结算
        public static final String SETTLED = "SETTLED";

    }


    public static class DictGoodsOrderPayWay {
        public static final String TYPE_CODE = "GOODS_ORDER_PAY_WAY";
        // 积分支付
        public static final String POINT = "POINT";
        // 现金支付
        public static final String CASH = "CASH";
        // 积分 + 现金混合支付
        public static final String POINT_AND_CASH = "POINT_AND_CASH";
    }

    public static class DictExpressDeliveryName {
        // 快递名称字典表
        public static final String TYPE_CODE = "EXPRESS_DELIVERY_NAME";
    }

    /**
     * 字典表类型
     */
    public class DictType {
        /** roco订单类型 */
        public final static String ROCO_TRADE_TYPE = "ROCO_TRADE_TYPE";
        /** 微信订单支付状态*/
        public final static String WX_TRADE_STATE="WX_TRADE_STATE";
        /** 微信支付交易类型*/
        public final static String WX_TRADE_TYPE="WX_TRADE_TYPE";
        /** 用户支付时使用的银行类型*/
        public final static String WX_BANK_TYPE="WX_BANK_TYPE";

        /** 微信退款状态 */
        public final static String WX_REFUND_STATUS = "WX_REFUND_STATUS";
        /** 微信订单退款发起来源*/
        public final static String WX_REFUND_REQUEST_SOURCE="WX_REFUND_REQUEST_SOURCE";
    }

}
