package com.rocogz.syy.order.entity.after;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description:售后单商品</dd>
 * <dd>@date: 2020/10/26</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@TableName("order_after_goods")
public class OrderAfterGoods extends IdEntity {
    /**
     * 售后单号
     */
    public String afterCode;

    /**
     * 订单编号
     */
    public String orderCode;

    /**
     * 子订单编号
     */
    public String subOrderCode;
    /**
     * 商品编码
     */
    private String goodsCode;
    /**
     * SKU编码
     */
    private String  skuCode;
    /**
     * 商品名称
     */
    private String goodsName;
    /**
     * 商品属性
     */
    private String goodsAttr;

    /**
     * 商品供应商编号
     */
    private String goodsSupplierCode;

    /**
     * 商品供应商名称
     */
    private String goodsSupplierName;



    /**
     * 商品的展示图片
     */
    private String goodsPictureUrl;

    /**
     * 是否虚拟商品
     */
    private Boolean virtualGoods;

    /**
     * 购买数量
     */
    private Integer buyNum;

    /**
     * 支付方式
     */
    private String payWay;

    /**
     * 单价
     */
    private BigDecimal goodsUnitPrice;

    /**
     * 原来商品支付总金额
     */
    private BigDecimal payedTotalCash;

    /**
     * 原来商品支付总积分
     */
    private BigDecimal payedTotalPoint;

    /**
     * 申请售后数量
     */
    private Integer afterNum;

    /**
     * 申请的退款金额
     */
    private BigDecimal refundApplyTotalCash;

    /**
     * 申请的退款积分
     */
    private BigDecimal refundApplyTotalPoint;


}
