/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.entity.orders;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.google.common.collect.Lists;
import com.rocogz.syy.order.entity.orders.BaseUserInfo;
import com.rocogz.syy.order.entity.orders.OrderPaymentRecord;
import com.rocogz.syy.order.util.ArithUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

public class OrderPayment
extends BaseUserInfo {
    private String payCode;
    private String payStatus;
    private BigDecimal payCent;
    private BigDecimal payAmt;
    private BigDecimal successAmt;
    private BigDecimal successCent;
    private String description;
    private LocalDateTime finishTime;
    private LocalDateTime updateTime;
    private String updateUser;
    @TableField(exist=false)
    private List<OrderPaymentRecord> recordList;
    @TableField(exist=false)
    private OrderPaymentRecord firstPayRecord;
    private transient String payStatusLabel;

    public void addRecord(OrderPaymentRecord record) {
        if (record == null) {
            return;
        }
        if (this.recordList == null) {
            this.recordList = Lists.newArrayList();
        }
        this.recordList.add(record);
    }

    public OrderPaymentRecord getFirstPayRecord() {
        if (this.firstPayRecord == null) {
            this.firstPayRecord = (OrderPaymentRecord)((Object)CollectionUtil.getFirst(this.recordList));
        }
        return this.firstPayRecord;
    }

    public BigDecimal getUnpayAmt() {
        if (this.payAmt == null || this.successAmt == null) {
            return null;
        }
        return ArithUtil.roundToBigDecimal(ArithUtil.bigDecimalSubtract(this.payAmt, this.successAmt), 3);
    }

    public BigDecimal getUnpayCent() {
        if (this.payCent == null || this.successCent == null) {
            return null;
        }
        return ArithUtil.roundToBigDecimal(ArithUtil.bigDecimalSubtract(this.payCent, this.successCent), 3);
    }

    public String getFmtPayAmt() {
        if (this.payAmt == null) {
            return "";
        }
        return ArithUtil.getNoSymbolCurrency(this.payAmt.doubleValue());
    }

    public String getFmtSuccessAmt() {
        if (this.successAmt == null) {
            return "";
        }
        return ArithUtil.getNoSymbolCurrency(this.successAmt.doubleValue());
    }

    public OrderPayment setPayCode(String payCode) {
        this.payCode = payCode;
        return this;
    }

    public OrderPayment setPayStatus(String payStatus) {
        this.payStatus = payStatus;
        return this;
    }

    public OrderPayment setPayCent(BigDecimal payCent) {
        this.payCent = payCent;
        return this;
    }

    public OrderPayment setPayAmt(BigDecimal payAmt) {
        this.payAmt = payAmt;
        return this;
    }

    public OrderPayment setSuccessAmt(BigDecimal successAmt) {
        this.successAmt = successAmt;
        return this;
    }

    public OrderPayment setSuccessCent(BigDecimal successCent) {
        this.successCent = successCent;
        return this;
    }

    public OrderPayment setDescription(String description) {
        this.description = description;
        return this;
    }

    public OrderPayment setFinishTime(LocalDateTime finishTime) {
        this.finishTime = finishTime;
        return this;
    }

    public OrderPayment setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public OrderPayment setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
        return this;
    }

    public OrderPayment setRecordList(List<OrderPaymentRecord> recordList) {
        this.recordList = recordList;
        return this;
    }

    public OrderPayment setFirstPayRecord(OrderPaymentRecord firstPayRecord) {
        this.firstPayRecord = firstPayRecord;
        return this;
    }

    public OrderPayment setPayStatusLabel(String payStatusLabel) {
        this.payStatusLabel = payStatusLabel;
        return this;
    }

    public String getPayCode() {
        return this.payCode;
    }

    public String getPayStatus() {
        return this.payStatus;
    }

    public BigDecimal getPayCent() {
        return this.payCent;
    }

    public BigDecimal getPayAmt() {
        return this.payAmt;
    }

    public BigDecimal getSuccessAmt() {
        return this.successAmt;
    }

    public BigDecimal getSuccessCent() {
        return this.successCent;
    }

    public String getDescription() {
        return this.description;
    }

    public LocalDateTime getFinishTime() {
        return this.finishTime;
    }

    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    public List<OrderPaymentRecord> getRecordList() {
        return this.recordList;
    }

    public String getPayStatusLabel() {
        return this.payStatusLabel;
    }
}

