package com.rocogz.syy.order.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单中心-商品订单
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-08-18
 */
@Setter @Getter
@Accessors(chain = true)
@TableName("order_goods_order")
public class GoodsOrder extends IdEntity {

    private static final long serialVersionUID = -6947173409061140577L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 是否虚拟商品
     */
    private Boolean virtual;

    /**
     * 虚拟商品类型：卡券(CARD)、 充值(DEPOSIT)、 碎屏险(SCREEN_CRASH_INSURANCE)、 电池券/换壳券(COUPON)
     */
    private String virtualType;

    /**
     * 商品供应商编号
     */
    private String supplierCode;

    /**
     * 商品供应商名称
     */
    private String supplierName;

    /**
     * sku编号
     */
    private String skuCode;

    /**
     * 主商品编号
     */
    private String goodCode;

    /**
     * 主商品名称
     */
    private String goodName;


    /**
     * 白色,xl
     */
    private String attrValues;

    /**
     * 商品展示图片url
     */
    private String pictureUrl;

    /**
     * 商品支付方式: 纯积分(CENT)、现金抵扣积分(CASH_DEDUCTION)、固定积分+固定现金(CENT_WITH_CASH)
     */
    private String goodPayWay;

    /**
     * 积分价
     * （1）"纯积分"支付方式：纯积分
     * （2）"现金抵扣兑换"支付方式：总积分
     * （3）"固定积分+固定现金"支付方式： 固定积分
     */
    private BigDecimal cent;

    /**
     * "现金抵扣兑换"支付方式下：需支付的最少积分
     */
    private BigDecimal minCent;

    /**
     *
     * "固定积分+固定现金" 支付方式下：固定现金价
     */
    private BigDecimal cash;


    /**
     * 商品购买数量
     */
    private Integer quantity;

    /**
     * 充值手机号：如果购买的是 充值虚拟商品(话费,流量)
     */
    private String depositMobile;

    /**
     * 订单现金金额[现金部分]
     */
    private BigDecimal totalCash;

    /**
     * 订单积分 [积分部分]
     */
    private BigDecimal totalCent;

    /**
     * 快递名称
     */
    private String expressDeliveryName;

    /**
     * 快递单号
     */
    private String expressDeliveryNumber;

    /**
     * 发货时间
     */
    private LocalDateTime sendTime;

    /**
     * 确认收货时间
     */
    private LocalDateTime receiveTime;

    /**
     * 完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 商品订单支付模式 (POINT:积分;  CASH:现金; POINT_AND_CASH:积分+现金)
     * @see com.rocogz.syy.order.constant.OrderConstant.DictGoodsOrderPayWay
     */
    private String payWay;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 收货地址信息[非虚拟商品才有收货地址]
     */
    @TableField(exist = false)
    private GoodsOrderDeliveryAddress goodsOrderDeliveryAddress;

}
