/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.order.constant.OtherInfoOption;
import com.rocogz.syy.order.constant.trace.BussiSystemEnum;
import com.rocogz.syy.order.constant.trace.BussiTypeEnum;
import com.rocogz.syy.order.constant.trace.CallApiEnum;
import com.rocogz.syy.order.dto.CancelOrderResultDto;
import com.rocogz.syy.order.dto.OrderCashPayDto;
import com.rocogz.syy.order.dto.after.AdminAfterOrderSearchParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderAdminCreateParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderAdminDeliveryLogisticsParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderLogisticsParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderMallCreateParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderOpeartorBaseParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderRefundParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderRefuseParamDto;
import com.rocogz.syy.order.dto.goods.CreateGoodsOrderDto;
import com.rocogz.syy.order.dto.goods.GoodsAdminSearchParamDto;
import com.rocogz.syy.order.dto.goods.GoodsOrderChangeStatusDto;
import com.rocogz.syy.order.dto.pay.WxPayRefundParamDto;
import com.rocogz.syy.order.dto.pay.WxPayUnifiedOrderParamDto;
import com.rocogz.syy.order.dto.pay.WxPayUnifiedOrderResultDto;
import com.rocogz.syy.order.dto.trace.ApiRequestLogStatisticsResponseDto;
import com.rocogz.syy.order.entity.after.OrderAfter;
import com.rocogz.syy.order.entity.after.OrderAfterLog;
import com.rocogz.syy.order.entity.goods.GoodsOrder;
import com.rocogz.syy.order.entity.orders.OrderLog;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import com.rocogz.syy.order.entity.pay.WxPayRecord;
import com.rocogz.syy.order.entity.pay.WxPayRefundRecord;
import com.rocogz.syy.order.entity.trace.OrderErrorTrace;
import com.rocogz.syy.order.entity.trace.OrderThirdTrace;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface IOrderClientService {
    @PostMapping(value={"/api/order/create"})
    public Response createOrder(@RequestBody SaleOrder var1);

    @GetMapping(value={"/api/order/getOrderMainInfo/{orderCode}"})
    public Response<SaleOrder> getOrderMainInfo(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/getOrderWithOtherInfo/{orderCode}"})
    public Response<SaleOrder> getOrderWithOtherInfo(@PathVariable(value="orderCode") String var1, @RequestParam(value="otherInfoList") List<OtherInfoOption> var2);

    @GetMapping(value={"/api/order/weappSearch"})
    public PageTable<SaleOrder> weappSearch(@RequestParam(value="userCode") String var1, @RequestParam(value="status", required=false) String var2, @RequestParam(value="orderTypeList", required=false) List<String> var3, @RequestParam(value="limit", defaultValue="10") Integer var4, @RequestParam(value="page", defaultValue="1") Integer var5);

    @GetMapping(value={"/api/order/delete/{orderCode}"})
    public Response<String> deleteLogical(@PathVariable(value="orderCode") String var1, @RequestParam(value="userCode", required=false) String var2);

    @GetMapping(value={"/api/order/cancelOrder/{orderCode}"})
    public Response<CancelOrderResultDto> cancelOrder(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/log/{orderCode}"})
    public Response<List<OrderLog>> findLogList(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/scheduleExpireOrder"})
    public Response<String> scheduleExpireOrder();

    @GetMapping(value={"/api/order/scheduleFindCashPayTimeoutOrderCodes"})
    public Response<List<String>> scheduleFindCashPayTimeOutOrderCodes();

    @PostMapping(value={"/api/order/writeOff/updateOrderStatus"})
    public Response<String> updateStatusWithSaveLog(@RequestBody List<OrderLog> var1);

    @GetMapping(value={"/api/order/trace/error"})
    public PageTable<OrderErrorTrace> searchErrorTrace(@RequestParam(value="coreCode", required=false) String var1, @RequestParam(value="bussType", required=false) BussiTypeEnum var2, @RequestParam(value="callApi", required=false) CallApiEnum var3, @RequestParam(value="system", required=false) BussiSystemEnum var4, @RequestParam(value="createStartTime", required=false) LocalDateTime var5, @RequestParam(value="createEndTime", required=false) LocalDateTime var6, @RequestParam(value="limit", defaultValue="20") int var7, @RequestParam(value="page", defaultValue="1") int var8);

    @PostMapping(value={"/api/order/trace/error/save"})
    public Response<String> saveErrorTrace(@RequestBody OrderErrorTrace var1);

    @GetMapping(value={"/api/order/trace/thirdApi"})
    public PageTable<OrderThirdTrace> searchThirdCallTrace(@RequestParam(value="coreCode", required=false) String var1, @RequestParam(value="callApiPath", required=false) String var2, @RequestParam(value="sourcePlatform", required=false) String var3, @RequestParam(value="targetPlatform", required=false) String var4, @RequestParam(value="createStartTime", required=false) LocalDateTime var5, @RequestParam(value="createEndTime", required=false) LocalDateTime var6, @RequestParam(value="limit", defaultValue="20") int var7, @RequestParam(value="page", defaultValue="1") int var8);

    @PostMapping(value={"/api/order/trace/thirdApi/save"})
    public Response<String> saveThirdCallTrace(@RequestBody OrderThirdTrace var1);

    @GetMapping(value={"/api/order/trace/thirdApi/pageQueryDistinctApiRequestInterface"})
    public PageTable<OrderThirdTrace> pageQueryDistinctApiRequestInterface(@RequestParam(value="callApiPath", required=false) String var1, @RequestParam(value="startTime") LocalDateTime var2, @RequestParam(value="endTime") LocalDateTime var3, @RequestParam(value="page", defaultValue="1") Integer var4, @RequestParam(value="limit", defaultValue="20") Integer var5);

    @GetMapping(value={"/api/order/trace/thirdApi/getStartTimeAndUsedTimeMillisList"})
    public Response<List<OrderThirdTrace>> getStartTimeAndUsedTimeMillisList(@RequestParam(value="callApiPath", required=false) String var1, @RequestParam(value="startTime") LocalDateTime var2, @RequestParam(value="endTime") LocalDateTime var3);

    @GetMapping(value={"/api/order/trace/thirdApi/statisticsMaxAndAverageUserTime"})
    public Response<ApiRequestLogStatisticsResponseDto> statisticsMaxAndAverageUserTimeApiList(@RequestParam(value="startTime") LocalDateTime var1, @RequestParam(value="endTime") LocalDateTime var2);

    @GetMapping(value={"/api/order/wx-pay-record/queryByRocoTradeNoAndStatus"})
    public Response<WxPayRecord> queryWxPayRecordByRocoTradeNoAndStatus(@RequestParam(value="rocoTradeNo") String var1, @RequestParam(value="wxTradeState", required=false) String var2);

    @PostMapping(value={"/api/order/wx-pay-record/updateById"})
    public Response updateWxPayRecordById(@RequestBody WxPayRecord var1);

    @GetMapping(value={"/api/order/wx-pay-record/queryPage"})
    public PageTable<WxPayRecord> wxPayRecordPageTable(@RequestParam(value="rocoTradeNo", required=false) String var1, @RequestParam(value="wxTransactionId", required=false) String var2, @RequestParam(value="wxUserOpenid", required=false) String var3, @RequestParam(value="rocoResCode", required=false) String var4, @RequestParam(value="rocoTradeType", required=false) String var5, @RequestParam(value="wxTradeState", required=false) String var6, @RequestParam(value="createTimeStart", required=false) String var7, @RequestParam(value="createTimeEnd", required=false) String var8, @RequestParam(value="wxTimeEndStart", required=false) String var9, @RequestParam(value="wxTimeEndEnd", required=false) String var10, @RequestParam(value="limit", defaultValue="20") int var11, @RequestParam(value="page", defaultValue="1") int var12);

    @GetMapping(value={"/api/order/wx-pay-record/wxPayRecordList"})
    public Response<List<WxPayRecord>> wxPayRecordList(@RequestParam(value="rocoTradeNo", required=false) String var1, @RequestParam(value="wxTransactionId", required=false) String var2, @RequestParam(value="wxUserOpenid", required=false) String var3, @RequestParam(value="rocoResCode", required=false) String var4, @RequestParam(value="rocoTradeType", required=false) String var5, @RequestParam(value="wxTradeState", required=false) String var6, @RequestParam(value="createTimeStart", required=false) String var7, @RequestParam(value="createTimeEnd", required=false) String var8, @RequestParam(value="wxTimeEndStart", required=false) String var9, @RequestParam(value="wxTimeEndEnd", required=false) String var10);

    @GetMapping(value={"/api/order/wx-pay-record/getWxPayRecordByTradeNo"})
    public Response<WxPayRecord> getWxPayRecordByTradeNo(@RequestParam(value="rocoTradeNo") String var1);

    @PostMapping(value={"/api/order/pay/wx/unifiedOrder"})
    public Response<WxPayUnifiedOrderResultDto> unifiedWxPayOrder(@RequestBody WxPayUnifiedOrderParamDto var1);

    @GetMapping(value={"/api/order/pay/wx/repayOrder"})
    public Response<WxPayUnifiedOrderResultDto> repayWxPayOrder(@RequestParam(value="outTradeNo") String var1);

    @GetMapping(value={"/api/order/pay/wx/closeOrder/{outTradeNo}"})
    public Response closeWxPayOrder(@PathVariable(value="outTradeNo") String var1);

    @PostMapping(value={"/api/order/pay/wx/refund"})
    public Response<String> refund(@RequestBody WxPayRefundParamDto var1);

    @GetMapping(value={"/api/order/wx-pay-refund-record/queryByRocoRefundNo"})
    public Response<WxPayRefundRecord> queryWxPayRefundRecordByRocoRefundNo(@RequestParam(value="rocoRefundNo") String var1);

    @PostMapping(value={"/api/order/wx-pay-refund-record/updateById"})
    public Response updateWxPayRefundRecordById(@RequestBody WxPayRefundRecord var1);

    @GetMapping(value={"/api/order/wx-pay-refund-record/queryPage"})
    public PageTable<WxPayRefundRecord> wxPayRefundRecordPageTable(@RequestParam(value="rocoTradeNo", required=false) String var1, @RequestParam(value="rocoRefundNo", required=false) String var2, @RequestParam(value="wxRefundId", required=false) String var3, @RequestParam(value="wxTransactionId", required=false) String var4, @RequestParam(value="wxUserOpenid", required=false) String var5, @RequestParam(value="rocoResCode", required=false) String var6, @RequestParam(value="rocoTradeType", required=false) String var7, @RequestParam(value="wxRefundStatus", required=false) String var8, @RequestParam(value="wxRefundRequestSource", required=false) String var9, @RequestParam(value="createTimeStart", required=false) String var10, @RequestParam(value="createTimeEnd", required=false) String var11, @RequestParam(value="wxRefundSuccessTimeStart", required=false) String var12, @RequestParam(value="wxRefundSuccessTimeEnd", required=false) String var13, @RequestParam(value="limit", defaultValue="20") int var14, @RequestParam(value="page", defaultValue="1") int var15);

    @GetMapping(value={"/api/order/wx-pay-refund-record/wxPayRefundRecordList"})
    public Response<List<WxPayRefundRecord>> wxPayRefundRecordList(@RequestParam(value="rocoTradeNo", required=false) String var1, @RequestParam(value="rocoRefundNo", required=false) String var2, @RequestParam(value="wxRefundId", required=false) String var3, @RequestParam(value="wxTransactionId", required=false) String var4, @RequestParam(value="wxUserOpenid", required=false) String var5, @RequestParam(value="rocoResCode", required=false) String var6, @RequestParam(value="rocoTradeType", required=false) String var7, @RequestParam(value="wxRefundStatus", required=false) String var8, @RequestParam(value="wxRefundRequestSource", required=false) String var9, @RequestParam(value="createTimeStart", required=false) String var10, @RequestParam(value="createTimeEnd", required=false) String var11, @RequestParam(value="wxRefundSuccessTimeStart", required=false) String var12, @RequestParam(value="wxRefundSuccessTimeEnd", required=false) String var13);

    @GetMapping(value={"/api/order/goods-order/adminSearch"})
    public PageTable<SaleOrder> adminSearchGoodsOrder(@SpringQueryMap GoodsAdminSearchParamDto var1);

    @PostMapping(value={"/api/order/goods-order/create"})
    public Response<SaleOrder> createGoodsOrder(@RequestBody CreateGoodsOrderDto var1);

    @GetMapping(value={"/api/order/goods-order/getByOrderCode"})
    public Response<GoodsOrder> getGoodsOrderByOrderCode(@RequestParam(value="orderCode") String var1);

    @PostMapping(value={"/api/order/goods-order/changeStatus"})
    public Response changeGoodsOrderStatus(@RequestBody GoodsOrderChangeStatusDto var1);

    @PostMapping(value={"/api/order/goods-order/cashPay"})
    public Response<String> payGoodsOrderByCash(@RequestBody OrderCashPayDto var1);

    @GetMapping(value={"/api/order/goods-order/listGoodsOrderByOrderCodes"})
    public Response<List<GoodsOrder>> listGoodsOrderByOrderCodes(@RequestParam(value="orderCodeList") List<String> var1);

    @GetMapping(value={"/api/order/pay/wx/paymentflow/failure"})
    public Response taskToFailureForOrder();

    @GetMapping(value={"/api/order/after/admin/adminAfterSearch"})
    public PageTable<OrderAfter> adminAfterSearch(@SpringQueryMap AdminAfterOrderSearchParamDto var1);

    @GetMapping(value={"/api/order/after/admin/afterApproveCallBlack"})
    public Response afterApproveCallBlack(@RequestParam(value="pass") String var1, @RequestParam(value="code") String var2, @RequestParam(value="remark") String var3, @RequestParam(value="updateUser") String var4);

    @PostMapping(value={"/api/order/after/admin/adminCreateAfter"})
    public Response<String> adminCreateAfter(@RequestBody AfterOrderAdminCreateParamDto var1);

    @PostMapping(value={"/api/order/after/admin/adminAfterRefund"})
    public Response adminAfterRefund(@RequestBody AfterOrderRefundParamDto var1);

    @PostMapping(value={"/api/order/after/admin/adminAfterRefuse"})
    public Response adminAfterRefuse(@RequestBody AfterOrderRefuseParamDto var1);

    @PostMapping(value={"/api/order/after/admin/adminAfterExchangeLogistics"})
    public Response adminAfterExchangeLogistics(@RequestBody AfterOrderAdminDeliveryLogisticsParamDto var1);

    @GetMapping(value={"/api/order/after/admin/getOrderAfterLog"})
    public Response<List<OrderAfterLog>> getOrderAfterLog(@RequestParam(value="afterCode") String var1);

    @GetMapping(value={"/api/order/after/admin/adminAfterDetail"})
    public Response<OrderAfter> adminAfterDetail(@RequestParam(value="afterCode") String var1);

    @GetMapping(value={"/api/order/after/mall/getMainOrderAfter"})
    public Response<OrderAfter> getMainOrderAfter(@RequestParam(value="afterCode") String var1, @RequestParam(value="userCode") String var2);

    @PostMapping(value={"/api/order/after/mall/mallCreateAfter"})
    public Response mallCreateAfter(@RequestBody AfterOrderMallCreateParamDto var1);

    @PostMapping(value={"/api/order/after/mall/mallAfterReturnLogistics"})
    public Response mallAfterReturnLogistics(@RequestBody AfterOrderLogisticsParamDto var1);

    @PostMapping(value={"/api/order/after/mall/mallAfterLogisticsConfirm"})
    public Response mallAfterLogisticsConfirm(@RequestBody AfterOrderOpeartorBaseParamDto var1);

    @GetMapping(value={"/api/order/after/mall/mallAfterSearch"})
    public PageTable<OrderAfter> mallAfterSearch(@RequestParam(value="userCode") String var1, @RequestParam(value="limit", defaultValue="10") Integer var2, @RequestParam(value="page", defaultValue="1") Integer var3);

    @GetMapping(value={"/api/order/after/mall/mallAfterDetail"})
    public Response<OrderAfter> mallAfterDetail(@RequestParam(value="afterCode") String var1);
}

