package com.rocogz.syy.order.entity.orders;

import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * 订单日志信息流水信息
 * @author zhangmin
 * @date 2020/4/30
 */
@Setter @Getter
@Accessors(chain = true)
public class OrderLog extends IdEntity {

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 操作
     * @see OrderConstant.DictOrderAction
     */
    private String action;

    /**
     * 操作之前的状态
     * @see OrderConstant.DictOrderStatus
     */
    private String beforeStatus;

    /**
     * 操作之后的状态
     * @see OrderConstant.DictOrderStatus
     */
    private String afterStatus;

    /**
     * 操作人名字
     */
    private String actionUser;

    /**
     * 操作时间戳
     */
    private LocalDateTime createTime;

    /**
     *备注说明
     */
    private String remark;


    //以下方便页面显示字段
    private transient String beforeStatusLabel;
    private transient String afterStatusLabel;
    private transient String actionLabel;

    public static OrderLog build() {
        OrderLog log = new OrderLog();
        log.setCreateTime(LocalDateTime.now());
        return log;
    }
}
