package com.rocogz.syy.order.entity.pay;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 订单中心-支付宝退款记录表
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-11-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_alipay_refund_record")
public class AlipayRefundRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * roco订单编码
     */
    private String rocoTradeNo;

    /**
     * roco退款流水号
     */
    private String rocoRefundFlowCode;

    /**
     * 记录支付成功回调之后，我们调用内部接口的返回状态码，用于判断调用内部接口是否成功，可以利用支付宝的多次回调机制进行重试
     */
    private String rocoResCode;

    /**
     * 记录支付宝回调之后，我们调用内部接口的次数
     */
    private Integer rocoTryCount;

    /**
     * 支付宝交易凭证号
     */
    private String alipayTradeNo;

    /**
     * 支付宝交易凭证号
     */
    private String alipayOutBizNo;

    /**
     * 支付宝分配给开发者的应用 ID
     */
    private String alipayAppId;

    /**
     * 买家支付宝用户号
     */
    private String alipayBuyerId;

    /**
     * 卖家支付宝用户号
     */
    private String alipaySellerId;

    /**
     * 交易状态
     */
    private String alipayTradeStatus;

    /**
     * 花呗分期数目
     */
    private Integer alipayHbFqNum;

    /**
     * 使用花呗分期需要卖家承担的手续费比例的百分值，100代表100%
     */
    private Integer alipayHbFqSellerPercent;

    /**
     * 本次交易支付的订单金额
     */
    private BigDecimal alipayTotalAmount;

    /**
     * 商家在交易中实际收到的款项
     */
    private BigDecimal alipayReceiptAmount;

    /**
     * 用户在交易中支付的可开发票的金额
     */
    private BigDecimal alipayInvoiceAmount;

    /**
     * 用户在交易中支付的金额
     */
    private BigDecimal alipayBuyerPayAmount;

    /**
     * 使用集分宝支付的金额
     */
    private BigDecimal alipayPointAmount;

    /**
     * 总退款金额
     */
    private BigDecimal alipayRefundFee;

    /**
     * 订单标题
     */
    private String alipaySubject;

    /**
     * 商品描述
     */
    private String alipayBody;

    /**
     * 通知的发送时间
     */
    private LocalDateTime alipayNotifyTime;

    /**
     * 交易创建时间
     */
    private LocalDateTime alipayGmtCreate;

    /**
     * 交易付款时间
     */
    private LocalDateTime alipayGmtPayment;

    /**
     * 交易的退款时间
     */
    private LocalDateTime alipayGmtRefund;

    /**
     * 交易结束时间
     */
    private LocalDateTime alipayGmtClose;

    /**
     * 支付成功的各个渠道金额信息
     */
    private String alipayFundBillList;

    /**
     * 回传参数
     */
    private String alipayPassbackParams;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
