package com.rocogz.syy.order.entity.trace;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Maps;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.util.TraceUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * @author zhangmin
 * @date 2020/5/28
 */
@Setter @Getter @Accessors(chain = true)
public abstract class BaseTrace extends IdEntity {

    /**
     * 核心编号：例如订单号，支付号,核销码,用户券编号等,方便最快的定位问题
     */
    private String coreCode;

    /**
     * 业务参数 json串
     */
    @TableField("buss_params")
    private String bussParamJson;

    /**
     * 返回消息
     */
    private String respMsg;

    /**
     * 返回状态码
     */
    private String respCode;

    /**
     * 接口耗时（毫秒数）
     */
    private Long spendMillis;

    /**
     * 接口调用开始时间
     */
    private LocalDateTime callStartTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 调用简短描述
     */
    private String description;

    //非持久化
    @JsonIgnore
    private transient Map<String,Object> bussParamMap;


    //返回xx秒
    public String getSpendTime() {
        return TraceUtils.prettyMillis(spendMillis);
    }

    /**
     * 加入业务参数
     * @return
     */
    public  BaseTrace putBussParam(String key,Object value) {
        if(StringUtils.isNotEmpty(key)) {
            if(bussParamMap == null) {
                this.bussParamMap = Maps.newLinkedHashMap();
            }
            bussParamMap.put(key,value);
        }
        return this;
    }


}
