/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.dto.jms;

import com.rocogz.syy.order.entity.goods.GoodsOrder;

public class NotifyPayResultToSamsungMsg {
    private String orderCode;
    private String coupon;
    private String type;
    private String memID;
    private String tranID;
    private String payCash;
    private String payPoint;
    private String payStageYN;
    private String payStageNum;

    public static NotifyPayResultToSamsungMsg valueOf(GoodsOrder goodOrder) {
        NotifyPayResultToSamsungMsg payResultMsg = new NotifyPayResultToSamsungMsg();
        payResultMsg.setCoupon(goodOrder.getSamsungCouponCode());
        payResultMsg.setType(goodOrder.getSamsungCouponType());
        payResultMsg.setOrderCode(goodOrder.getOrderCode());
        payResultMsg.setTranID(goodOrder.getOrderCode());
        payResultMsg.setMemID(goodOrder.getSamsungMemId());
        payResultMsg.setPayCash(String.valueOf(goodOrder.getTotalCash()));
        payResultMsg.setPayPoint(String.valueOf(goodOrder.getTotalCent().intValue()));
        payResultMsg.setPayStageYN("N");
        if (goodOrder.getAlipaySuccessRecord() != null && goodOrder.getAlipaySuccessRecord().getAlipayHbFqNum() != null && goodOrder.getAlipaySuccessRecord().getAlipayHbFqNum() > 0) {
            payResultMsg.setPayStageYN("Y");
            payResultMsg.setPayStageNum(String.valueOf(goodOrder.getAlipaySuccessRecord().getAlipayHbFqNum()));
        }
        return payResultMsg;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public void setCoupon(String coupon) {
        this.coupon = coupon;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMemID(String memID) {
        this.memID = memID;
    }

    public void setTranID(String tranID) {
        this.tranID = tranID;
    }

    public void setPayCash(String payCash) {
        this.payCash = payCash;
    }

    public void setPayPoint(String payPoint) {
        this.payPoint = payPoint;
    }

    public void setPayStageYN(String payStageYN) {
        this.payStageYN = payStageYN;
    }

    public void setPayStageNum(String payStageNum) {
        this.payStageNum = payStageNum;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public String getCoupon() {
        return this.coupon;
    }

    public String getType() {
        return this.type;
    }

    public String getMemID() {
        return this.memID;
    }

    public String getTranID() {
        return this.tranID;
    }

    public String getPayCash() {
        return this.payCash;
    }

    public String getPayPoint() {
        return this.payPoint;
    }

    public String getPayStageYN() {
        return this.payStageYN;
    }

    public String getPayStageNum() {
        return this.payStageNum;
    }
}

