package com.rocogz.syy.order.entity.after;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:售后处理的节点流程记录,商城端展示使用 </dd>
 * <dd>@date: 2020/10/26</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@TableName("order_after_process_record")
@Setter
@Getter
@Accessors(chain = true)
public class OrderAfterProcessRecord extends IdEntity {

    /**
     * 售后单号
     */
    private String afterCode;
    /**
     * 订单编号
     */
    private String orderCode;
    /**
     * 售后类型
     */
    private String afterType;
    /**
     * 售后处理节点-节点编码
     * @Link OrderAfterConstant.ConstantDataOrderAfterNode
     */
    private String nodeCode;
    /**
     * 售后节点的名称
     */
    private String nodeName;
    /**
     * 售后节点的提示语
     */
    private String nodeTip;
    /**
     * 操作内容
     */
    private String nodeContent;

    /**
     * 退货的快递公司编码
     */
    private String returnLogisticsCode;

    /**
     * 退货的快递公司名称
     */
    private String returnLogisticsName;

    /**
     * 退货的快递物流单号
     */
    private String returnLogisticsNo;

    /**
     * 换货的快递公司编码
     */
    private String deliveryLogisticsCode;

    /**
     * 换货的快递公司名称
     */
    private String deliveryLogisticsName;

    /**
     * 换货的物流单号
     */
    private String deliveryLogisticsNo;

    /**
     * 当前节点的操作用户类型：用户还是后台管理员
     */
    private String userType;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;




}
