package com.rocogz.syy.order.constant;

/**
 * 微信支付流水状态
 * @author：liangyongtong
 * @since：2020/9/8
 */
public class PaymentFlowConstant {

    public enum Origin {
        GIFT("投保礼");

        private String label;

        Origin(String label) {
            this.label = label;
        }

        public String getLabel() {
            return label;
        }
    }

    public enum PayWay {
        WX("微信"), ALIPAY("支付宝");

        private String Label;

        PayWay(String label) {
            Label = label;
        }

        public String getLabel() {
            return Label;
        }
    }
    public enum Status {
        PAYING("支付中"), INVALID("失效"), COMPLETE("完成"), REFUND("退款");

        private String Label;

        Status(String label) {
            Label = label;
        }

        public String getLabel() {
            return Label;
        }
    }

    public class RedisKey {
        /** 微信支付生成的业务号 */
        public final static String WX_PAYMENT_BUSINESSCODE = "WX_PAYMENT_BUSINESSCODE";
    }
}
