/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.dto.jms;

import com.rocogz.syy.order.entity.goods.GoodsOrder;
import java.time.LocalDateTime;

public class NotifyPayResultToSamsungMsg {
    private Integer retryTimes;
    private Boolean butlerService;
    private String orderCode;
    private String coupon;
    private String type;
    private String memID;
    private String tranID;
    private String payCash;
    private String payPoint;
    private String payStageYN;
    private String payStageNum;
    private String mobileModel;
    private LocalDateTime createTime;
    private String imei;

    public static NotifyPayResultToSamsungMsg valueOf(GoodsOrder goodOrder) {
        NotifyPayResultToSamsungMsg payResultMsg = new NotifyPayResultToSamsungMsg();
        payResultMsg.setCoupon(goodOrder.getSamsungCouponCode());
        payResultMsg.setType(goodOrder.getSamsungCouponType());
        payResultMsg.setOrderCode(goodOrder.getOrderCode());
        payResultMsg.setTranID(goodOrder.getOrderCode());
        payResultMsg.setMemID(goodOrder.getSamsungMemId());
        double payCash = goodOrder.getTotalCash().doubleValue() * 100.0;
        payResultMsg.setPayCash(String.valueOf((int)payCash));
        payResultMsg.setPayPoint(String.valueOf(goodOrder.getTotalCent().intValue()));
        payResultMsg.setMobileModel(goodOrder.getMobileModel());
        payResultMsg.setCreateTime(goodOrder.getCreateTime());
        payResultMsg.setImei(goodOrder.getImei());
        payResultMsg.setButlerService(goodOrder.getButlerService());
        payResultMsg.setPayStageYN("N");
        payResultMsg.setRetryTimes(goodOrder.getNotifyRetryTimes());
        if (goodOrder.getAlipaySuccessRecord() != null && goodOrder.getAlipaySuccessRecord().getAlipayHbFqNum() != null && goodOrder.getAlipaySuccessRecord().getAlipayHbFqNum() > 0) {
            payResultMsg.setPayStageYN("Y");
            payResultMsg.setPayStageNum(String.valueOf(goodOrder.getAlipaySuccessRecord().getAlipayHbFqNum()));
        }
        return payResultMsg;
    }

    public void setRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
    }

    public void setButlerService(Boolean butlerService) {
        this.butlerService = butlerService;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public void setCoupon(String coupon) {
        this.coupon = coupon;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMemID(String memID) {
        this.memID = memID;
    }

    public void setTranID(String tranID) {
        this.tranID = tranID;
    }

    public void setPayCash(String payCash) {
        this.payCash = payCash;
    }

    public void setPayPoint(String payPoint) {
        this.payPoint = payPoint;
    }

    public void setPayStageYN(String payStageYN) {
        this.payStageYN = payStageYN;
    }

    public void setPayStageNum(String payStageNum) {
        this.payStageNum = payStageNum;
    }

    public void setMobileModel(String mobileModel) {
        this.mobileModel = mobileModel;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public Integer getRetryTimes() {
        return this.retryTimes;
    }

    public Boolean getButlerService() {
        return this.butlerService;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public String getCoupon() {
        return this.coupon;
    }

    public String getType() {
        return this.type;
    }

    public String getMemID() {
        return this.memID;
    }

    public String getTranID() {
        return this.tranID;
    }

    public String getPayCash() {
        return this.payCash;
    }

    public String getPayPoint() {
        return this.payPoint;
    }

    public String getPayStageYN() {
        return this.payStageYN;
    }

    public String getPayStageNum() {
        return this.payStageNum;
    }

    public String getMobileModel() {
        return this.mobileModel;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public String getImei() {
        return this.imei;
    }
}

