package com.rocogz.syy.order.dto.invoice;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 三星生活助手订单, 下线模式下单 发票信息
 * 前端提交的 发票信息
 * @author zhangmin
 * @date 2020/11/27
 */
@Accessors(chain = true)
@Setter  @Getter
public class InvoiceDto {

    //如果的申请单号
    private String applyCode;

    //发票的订单号
    private String orderCode;

    private String unionId;

    //开票金额
    private BigDecimal invoiceAmount;

    //是否开 发票
    private Boolean hasInvoice;

    /**
     * 发票抬头：北京吉祥如意科技股份有限公司
     */
    private String invoiceTitle;

    /**
     * 发票的接收方式
     * {@link com.rocogz.syy.order.constant.OrderConstant.OrderInvoiceReceiveWay}
     */
    private String receiveWay;

    /**
     * 发票类型
     * {@link com.rocogz.syy.order.constant.OrderConstant.OrderInvoiceType}
     */
    private String invoiceType;

    /**
     * 抬头类型
     * {@link com.rocogz.syy.order.constant.OrderConstant.OrderInvoiceTitleType}
     */
    private String titleType;

    /**
     * 发票税号 例如：309184185781487618
     */
    private String invoiceNo;

    /**
     * 接收发票的手机号R
     */
    private String mobile;

    /**
     * 接收发票的电子邮箱
     */
    private String email;
}
