package com.rocogz.syy.order.dto;


import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Getter;
import lombok.Setter;

/**
 * 下单的系统参数[后端业务接口调用方]
 * @author zhangmin
 * @date 2020/6/12
 */
@Setter @Getter
public class SystemParamDto {

    /**
     * 订单类型编号：服务券订单，电子券订单，预约订单 [必传]
     *
     * @see OrderConstant.DictOrderType
     */
    private String orderType;

    /**
     * 支付方式：电子券支付，服务券兑换
     *
     * @see OrderConstant.DictPayWay [必传]
     */
    private String payWay;

    /**
     * 下单来源平台编号，如：syy  [必传]
     * 该平台编号来源于 基础服务系统中：basic_docking_platform表
     */
    private String platformCode;

    /**
     * 下单渠道：车主端，商户端，管理后台,接口调用 [必传]
     *
     * @see OrderConstant.DictChannel
     */
    private String channel;
}
