package com.rocogz.syy.order.entity.orders;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.entity.goods.GoodsOrder;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 订单主信息表
 * </p>
 *
 * @author zhangmin
 * @since 2020-04-26
 */
@TableName("order_sale_order")
@Setter
@Getter
@Accessors(chain = true)
public class SaleOrder extends BaseUserInfo {

    private static final long serialVersionUID = 1L;

    /**
     * 订单类型编号：服务券订单，加油电子券订单，预约订单
     *
     * @see OrderConstant.DictOrderType
     */
    private String orderType;

    /**
     * 下单来源平台编号，如：SYY
     * 该平台码来源于 基础服务系统中：basic_docking_platform表
     * @see OrderConstant#DICT_PLATFORM_CODE_CENT_MALL
     */
    private String platformCode;

    /**
     * 下单渠道：车主端，商户端，管理后台,接口调用
     *
     * @see OrderConstant.UserVisitChannel
     */
    private String channel;

    /**
     * 订单状态：处理中,待支付，待使用，待评价，已评价，已取消，已过期
     *
     * @see OrderConstant.DictOrderStatus
     */
    private String status;

    /**
     * 取消订单时间
     */
    private LocalDateTime cancelTime;

    /**
     * 订单过期时间：例如三星碎屏险订单的 支付过期时间
     */
    private LocalDateTime expireTime;

    /**
     * 是否被逻辑删除,即是否被会员自己删除了
     */
    private Boolean deleted;

    //支付单
    @TableField(exist = false)
    private OrderPayment payment;

    /**
     * 商品订单信息[商品订单 专有]
     */
    @TableField(exist = false)
    private GoodsOrder goodsOrder;



    /**
     * =====> 以下都是为了页面展示数据用的
     */
    private transient String orderTypeLabel;
    private transient String statusLabel;
    private transient String channelLabel;
    //平台名称
    private transient String platformName;


    //hhl增加,为了直观判断是否能再次售后
    //adminSearch 售后操作 按钮判断
    @TableField(exist = false)
    private String afterCode;

    //是否允许售后服务[是否能看见售后按钮]
    private transient Boolean afterSaleAllowed;
}
