package com.rocogz.syy.order.dto;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: OrderCentPayDto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/8/19 16:49</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Setter @Getter
@Accessors(chain = true)
public class OrderCentPayDto {

    /**
     * 订单编号
     */
    @NotEmpty
    private String orderCode;

    /**
     * 支付的积分[必须]
     */
    @NotNull
    private BigDecimal payCent;

    /**
     * 扣分 批准号码,也是三星订单号,三星扣分接口返回给我们此字段
     */
    private String apprNo;
}